package {
    import flash.display.*;
    import flash.events.*;
    import flash.text.*;
    import flash.utils.*;
    
    //マウスイベントを処理する
    public class MouseEx extends Sprite {
        private var label:TextField;         //ラベル
        private var mouseDown:String ="アップ";//マウスダウン
        private var mouseDelta:int   =0;     //マウスホイール

        //コンストラクタ
        public function MouseEx() {
            //クリック対象となるスプライトの追加
            var base:Sprite=new Sprite();
            base.graphics.beginFill(0xFFFFFF);
            base.graphics.drawRect(0,0,240,240);
            base.graphics.endFill();
            addChild(base);

            //ラベルの追加
            label=makeLabel("マウスイベント");
            base.addChild(label);
            
            //イベントリスナーの追加
            base.addEventListener(MouseEvent.MOUSE_DOWN,mouseDownHandler);
            base.addEventListener(MouseEvent.MOUSE_UP,mouseUpHandler);
            base.addEventListener(MouseEvent.MOUSE_WHEEL,mouseWheelHandler);

            //タイマーの追加
            var timer:Timer=new Timer(100,0);
            timer.addEventListener(TimerEvent.TIMER,onTick);
            timer.start();
        }
        
        //マウスダウンイベントの処理
        private function mouseDownHandler(evt:MouseEvent):void {
            mouseDown="ダウン";
        }

        //マウスアップイベントの処理
        private function mouseUpHandler(evt:MouseEvent):void {
            mouseDown="アップ";
        }
    
        //マウスホイールイベントの処理
        private function mouseWheelHandler(evt:MouseEvent):void {
            mouseDelta=evt.delta;
        }
        
        //タイマーイベントの処理
        private function onTick(evt:TimerEvent):void {
            var text:String="";
            text+="マウスダウン："+mouseDown+"\n";
            text+="マウス座標："+Math.floor(mouseX)+","+Math.floor(mouseY)+"\n";
            text+="マウスホイール："+mouseDelta;
            label.text=text;
            mouseDelta=0;
        }        
        
        //ラベルの生成
        private function makeLabel(text:String):TextField {
            var label:TextField=new TextField();
            label.text=text;
            label.autoSize=TextFieldAutoSize.LEFT;
            label.selectable=false;
            return label;
        }
    }
}