package {
    import flash.display.*;
    import flash.events.*;
    import flash.media.*;
    import flash.text.*;

	//マイクを利用する
    public class MicrophoneEx extends Sprite {
        private var label:TextField;//ラベル
        private var mic:Microphone; //マイク
    	
    	//コンストラクタ
        public function MicrophoneEx() {
        	//ラベルの生成
        	label=addLabel("MicrophoneEx");

        	//マイクの取得
            mic=Microphone.getMicrophone();
                    
           	if (mic!=null) {
	            //ローカルスピーカーにマイク音を送る
    	        mic.setLoopBack(true);
				//エコー抑制機能の利用
                mic.setUseEchoSuppression(true);
                //イベントリスナーの追加
                mic.addEventListener(StatusEvent.STATUS,statusHandler);
                mic.addEventListener(ActivityEvent.ACTIVITY,activityHandler);
            } else {
                label.text="マイクを利用できません"; 
            }
        }

		//状態イベントの処理
        private function statusHandler(evt:StatusEvent):void {
            if (mic.muted) {
                label.text="マイクを利用できません";
            } else {
                label.text="マイクから入力して下さい";
            }
        }

        //アクティビティイベントの処理
        private function activityHandler(evt:ActivityEvent):void {
            if (evt.activating) {
                label.text="サウンドの検知を開始";
            } else {
                label.text="サウンドの検知を停止";
            }
        }
        
        //ラベルの追加
        private function addLabel(text:String):TextField {
            var label:TextField=new TextField();
            label.autoSize=TextFieldAutoSize.LEFT;
            label.text=text;
            addChild(label);     
            return label;      
        }
    }
}