package {
    import flash.display.*;
    import flash.events.*;
    import flash.filters.*
    import flash.text.*;

    //フィルタを使用する
    public class FilterEx extends Sprite {
        //素材クラスの定義
        [Embed(source='sample.swf')]
        private var Sample:Class;
        
        //変数
        private var label:TextField;//ラベル
        private var sample:Sprite;  //アニメ0
        private var type:int=0;     //種別

        //コンストラクタ
        public function FilterEx() {
            //ラベルの追加
            label=new TextField();
            label.autoSize=TextFieldAutoSize.LEFT;
            addChild(label); 
            
            //素材オブジェクトの生成
            sample=new Sample();
            sample.x=120;
            sample.y=120;
            sample.addEventListener(MouseEvent.MOUSE_DOWN,mouseDownHandler);
            addChild(sample);
            
            //フィルタの指定
            setFilter(type);
        }

        //マウスダウンイベントの処理
        private function mouseDownHandler(evt:MouseEvent):void {
            if (++type>5) type=0;
            setFilter(type);
        }
        
        //フィルタの指定
        private function setFilter(type:int):void {
            //フィルタの生成
            var filters:Array=new Array();
            if (type==0) {
                label.text="なし";
            } else if (type==1) {
                label.text="ブラーフィルタ";
                filters.push(makeBlurFilter());
            } else if (type==2) {
                label.text="ベベルフィルタ";
                filters.push(makeBevelFilter());
            } else if (type==3) {
                label.text="ドロップシャドウフィルタ";
                filters.push(makeDropShadowFilter());
            } else if (type==4) {
                label.text="グローフィルタ";
                filters.push(makeGlowFilter());
            }
            //フィルタの指定
            sample.filters=filters;           
        }

        //ブラーフィルタの生成
        private function makeBlurFilter():BitmapFilter {
            var filter:BlurFilter=new BlurFilter();
            filter.blurX  =4;//水平方向のぼかし量
            filter.blurY  =4;//垂直方向のぼかし量
            filter.quality=BitmapFilterQuality.HIGH;//クォリティ
            return filter;
        }

        //ベベルフィルタの生成
        private function makeBevelFilter():BitmapFilter {
            var filter:BevelFilter=new BevelFilter();
            filter.angle         =45;      //角度
            filter.blurX         =3;       //水平方向のぼかし量
            filter.blurY         =3;       //垂直方向のぼかし量
            filter.distance      =10;      //オフセットの距離
            filter.highlightAlpha=0.5;     //ハイライトカラーの透明度
            filter.highlightColor=0xddddff;//ハイライトカラー
            filter.knockout      =false;   //ノックアウト効果有無
            filter.quality       =BitmapFilterQuality.HIGH;//クォリティ
            filter.shadowAlpha   =0.8;     //シャドウカラーの透明度
            filter.shadowColor   =0x000000;//シャドウカラー
            filter.strength      =0.5;     //インプリントやスプレッドの長さ
            filter.type          =BitmapFilterType.INNER;//ベベルの種類
            return filter;
        }

        //ドロップシャドウフィルタの生成
        private function makeDropShadowFilter():BitmapFilter {
            var filter:DropShadowFilter=new DropShadowFilter();
            filter.alpha     =0.5;     //シャドウカラーの透明度
            filter.angle     =45;      //シャドウの角度
            filter.blurX     =5;       //水平方向のぼかし量
            filter.blurY     =5;       //垂直方向のぼかし量
            filter.color     =0x000000;//シャドウのカラー
            filter.distance  =5;       //シャドウのオフセット距離
            filter.hideObject=false;   //シャドウのみの表示
            filter.inner     =false;   //内部シャドウか
            filter.knockout  =false;   //ノックアウト効果の有無
            filter.quality   =BitmapFilterQuality.HIGH;//クォリティ
            filter.strength  =1;       //インプリントやスプレッドの長さ
            return filter;
        }

        //グローフィルタの生成
        private function makeGlowFilter():BitmapFilter {
            var filter:GlowFilter=new GlowFilter();
            filter.color   =0xff0000;//グローの色
            filter.alpha   =1.0;     //カラーの透明度
            filter.blurX   =20;      //水平方向のぼかし量
            filter.blurY   =20;      //垂直方向のぼかし量
            filter.inner   =true;    //内側グロー
            filter.knockout=false;   //ノックアウト効果の有無
            filter.quality =BitmapFilterQuality.HIGH;//クォリティ
            filter.strength=1;       //インプリントやスプレッドの長さ
            return filter;
        }
    }
}