package {
    import flash.display.*;
    import flash.events.*
    import flash.text.*;
    
    //シンプルボタン
    public class SimpleButtonEx extends Sprite {
    	private var label:TextField;    //ラベル
    	private var button:CustomButton;//ボタン 
    	   
        //コンストラクタ
        public function SimpleButtonEx() {
        	//ラベルの追加
        	label=makeLabel("カスタムボタン");
        	addChild(label);

            //カスタムボタンの追加
            button=new CustomButton();
            button.x=80;
            button.y=80;
            addChild(button);
            button.addEventListener(MouseEvent.MOUSE_DOWN,mouseDownHandler);
            button.addEventListener(MouseEvent.MOUSE_UP,mouseUpHandler);
            button.addEventListener(MouseEvent.MOUSE_OVER,mouseOverHandler);
            button.addEventListener(MouseEvent.MOUSE_OUT,mouseOutHandler);
        }

        //マウスダウンイベントの処理
        private function mouseDownHandler(evt:MouseEvent):void {
        	label.text="マウスダウン";
        }

        //マウスアップイベントの処理
        private function mouseUpHandler(evt:MouseEvent):void {
        	label.text="マウスアップ";
        }

        //マウスオーバーイベントの処理
        private function mouseOverHandler(evt:MouseEvent):void {
        	label.text="マウスオーバー";
        }

        //マウスアップの処理
        private function mouseOutHandler(evt:MouseEvent):void {
        	label.text="マウスアウト";
        }

        //ラベルの生成
        private function makeLabel(text:String):TextField {
            var label:TextField=new TextField();
            label.text      =text;
            label.autoSize  =TextFieldAutoSize.LEFT;
            label.selectable=false;
            return label;
        }
    }
}