package {
    import flash.display.*;
    import flash.events.*;
    import flash.media.*;
    import flash.text.*;

	//WEBカメラを利用する
    public class CameraEx extends Sprite {
    	private var label:TextField;//ラベル
        private var camera:Camera;  //カメラ

        //コンストラクタ
        public function CameraEx() {
        	//ラベル
        	label=addLabel("CameraEx");

            //カメラの取得
            camera=Camera.getCamera();           

            if (camera!=null) {
                //イベントリスナーの追加
                camera.addEventListener(StatusEvent.STATUS,statusHandler);
                camera.addEventListener(ActivityEvent.ACTIVITY,activityHandler);
               
                //ビデオの生成
                var video:Video=new Video(200,200);
                video.attachCamera(camera);
                addChild(video);
                video.x=20;
                video.y=20;
            } else {
                label.text="カメラを利用できません";
            }
        }

		//状態イベントの処理
        private function statusHandler(evt:StatusEvent):void {
            if (camera.muted) label.text="カメラを利用できません";
        }

        //アクティビティイベントの処理
        private function activityHandler(evt:ActivityEvent):void {
            if (evt.activating) {
                label.text="モーションの検知を開始";
            } else {
                label.text="モーションの検知を停止";
            }
        }
        
        //ラベルの追加
        private function addLabel(text:String):TextField {
            var label:TextField=new TextField();
            label.autoSize=TextFieldAutoSize.LEFT;
            label.text=text;
            addChild(label);
            return label;           
        }
    }
}