package {
    import flash.display.*;
    import flash.events.*;
    import flash.ui.*;
    import flash.utils.*;
    
    //アクションゲーム
    public class ActionGame extends Sprite {
	    //シーン定数
	    private static const S_TITLE:int   =0;//タイトル
	    private static const S_PLAY:int    =1;//プレイ
	    private static const S_GAMEOVER:int=2;//ゲームオーバー

        //素材クラス
        [Embed(source='0.gif')]
        private var Image0:Class;
        [Embed(source='1.gif')]
        private var Image1:Class;
        [Embed(source='2.gif')]
        private var Image2:Class;
        [Embed(source='3.gif')]
        private var Image3:Class;
        [Embed(source='4.gif')]
        private var Image4:Class;
        [Embed(source='5.gif')]
        private var Image5:Class;

        //素材オブジェクト
        private var image:Array=new Array(6);//イメージ

        //システム
        private var init:int =S_TITLE;//初期化
        private var scene:int=S_TITLE;//シーン
        private var score:int;        //スコア
        private var keyCode:int;      //キーコード
        private var base:Sprite;      //クリック対象
        
        //変数
        private var g:JGraphics;                //グラフィックス
        private var ratY:int;                   //ラットのY座標 
        private var ratAngle:Number;            //ラットの角度
        private var cheeseX:Array=new Array(20);//チーズのX座標
        private var cheeseY:Array=new Array(20);//チーズのY座標

        //コンストラクタ
        public function ActionGame() {
            //素材オブジェクトの生成
            image[0]=new Image0();
            image[1]=new Image1();
            image[2]=new Image2();
            image[3]=new Image3();
            image[4]=new Image4();
            image[5]=new Image5();

            //クリック対象
            base=new Sprite();
            base.graphics.beginFill(0xFFFFFF);
            base.graphics.drawRect(0,0,640,480);
            base.graphics.endFill();
            base.focusRect=false;
            addChild(base);

        	//JGraphicsオブジェクトの生成
        	g=new JGraphics(640,480);
        	
        	//Bitmapオブジェクトの追加
            base.addChild(new Bitmap(g.getBitmapData()));

            //イベントリスナーの追加
            base.addEventListener(KeyboardEvent.KEY_DOWN,keyDownHandler);
            base.addEventListener(MouseEvent.CLICK,clickHandler); 

            //タイマーの追加
            var timer:Timer=new Timer(50,0);
            timer.addEventListener(TimerEvent.TIMER,onTick);
            timer.start();
        }

        //タイマーイベントの処理
        private function onTick(evt:TimerEvent):void {
        	var i:int,scrollX:int;

            //シーンの初期化
            if (init>=0) {
                //タイトル
                if (init==S_TITLE) {
                    score   =0;
                    ratY    =2;
                    ratAngle=0;
                    for (i=0;i<20;i++) cheeseX[i]=-50;
                }
                //共通の初期化
                scene  =init;
                init   =-1;
                keyCode=-999;
            }

			//背景の描画
            scrollX=-64-(score%8)*16;
            g.setColor(g.getColorOfRGB(128,128,255));
            g.fillRect(0,0,640,480);
			for (i=0;i<8;i++) {
                g.drawImage(image[2],scrollX+i*128,380);
                g.drawImage(image[3],scrollX+i*128,60);
	            g.drawImage(image[4],scrollX+i*128,     220);
	            g.drawImage(image[4],scrollX+i*128-48,  220+32);
	            g.drawImage(image[4],scrollX+i*128-48*2,220+32*2);
	            g.drawImage(image[4],scrollX+i*128-48*3,220+32*3);
	            g.drawImage(image[4],scrollX+i*128-48*4,220+32*4);
            }
            
            //チーズの処理
            for (i=0;i<20;i++) {
            	//停止中
            	if (cheeseX[i]<=-50) {
            		//出現
            		if (scene==S_PLAY && Util.rand(100)<3) {
            			cheeseX[i]=690;
            			cheeseY[i]=Util.rand(5);	
            		}            		
            	} 
            	//移動中
            	else {
            		if (scene==S_PLAY) {
	            		//移動
    	        		cheeseX[i]-=16;
						//衝突判定
            			if (Util.calcLen(80,240+32*ratY,
            				cheeseX[i],240+32*cheeseY[i])<900) {
            				init=S_GAMEOVER;
            			}
            		}
            		//描画
            		g.drawImage(image[5],cheeseX[i]-21,240-20+32*cheeseY[i]);
	            }
	        }

            //ラットの描画
            if (scene!=S_GAMEOVER) {
	            g.drawImage(image[score%2],80-20,240-52+32*ratY);
            } else {
            	if (ratAngle<Math.PI*6) ratAngle+=Math.PI/6;
            	g.drawImage(image[1],80-20,240-52+32*ratY,ratAngle);
            }

            //スコアの描画
            g.setColor(g.getColorOfName(JGraphics.WHITE));
            g.setFontSize(30);
            g.drawString("SCORE:"+score,12,50);

            //タイトル時の処理
            if (scene==S_TITLE) {
            	//描画
	            g.setColor(g.getColorOfRGB(255,50,50));
	            g.setFontSize(50);
	            g.drawString("ラットロクロス",
	            	(640-g.stringWidth("ラットロクロス"))/2,180);
	            
	            //キーイベント
                if (keyCode==Keyboard.ENTER) init=S_PLAY;
            	keyCode=-999;
            }

            //プレイ時の処理
            if (scene==S_PLAY) {
                //スコア加算
                score++;
                
                //キーイベント
                if (keyCode==Keyboard.UP) {
                	if (ratY>0) ratY--;                
                } else if (keyCode==Keyboard.DOWN) {
                	if (ratY<4) ratY++;                
                }
                keyCode=-999;
            }

            //ゲームオーバー時の処理
            if (scene==S_GAMEOVER) {
            	//描画
	            g.setColor(g.getColorOfRGB(255,50,50));
	            g.setFontSize(60);
	            g.drawString("ゲームオーバー",
	            	(640-g.stringWidth("ゲームオーバー"))/2,180);

				//キーイベント
                if (keyCode==Keyboard.ENTER) init=S_TITLE;
            	keyCode=-999;
            }
        }
    
        //キーダウンイベントの処理
        private function keyDownHandler(evt:KeyboardEvent):void {
        	keyCode=evt.keyCode;
        }

        //マウスクリックイベントの処理
        private function clickHandler(evt:MouseEvent):void {
            stage.focus=base;
        }
    }
}
