package {
    import flash.display.*;
    import flash.events.*;
    import flash.net.*;
    import flash.system.*;
    import flash.text.*;

    //ネットからXMLを読み込む
    public class XMLEx extends Sprite {
        private var loader:URLLoader;//ローダー
        private var label:TextField; //ラベル

        //コンストラクタ
        public function XMLEx() {
            //ラベルの追加
            label=addLabel("XMLEx");

            //URLローダーの生成
            loader=new URLLoader();
            
            //リスナーの追加
            loader.addEventListener(ProgressEvent.PROGRESS,progressHandler);
            loader.addEventListener(Event.COMPLETE,completeHandler);
            loader.addEventListener(SecurityErrorEvent.SECURITY_ERROR,securityErrorHandler);
            loader.addEventListener(IOErrorEvent.IO_ERROR,ioErrorHandler);
                        
            //読み込み開始
            loader.load(new URLRequest("sample.xml"));
        }

        //読み込み中イベントの処理
        private function progressHandler(evt:ProgressEvent):void {
            label.text="読み込み中:"+loader.bytesLoaded+"/"+loader.bytesTotal;
        }

        //読み込み完了イベントの処理
        private function completeHandler(evt:Event):void {
            var text:String="";

            //XMLの生成
            var mails:XML=new XML(loader.data);

            //0番目のメール本文
            text+="0番目のメール本文："+mails.mail[0]+"\n";
           
            //0番目のメールのfrom
            text+="0番目のメールのfrom："+mails.mail[0].@from+"\n";

            //0番目のメールのto
            text+="0番目のメールのto："+mails.mail[0].@to+"\n";

            //全メール本文       
            text+="全メール本文\n";
            for (var i:int=0;mails.mail[i]!=null;i++) {
                text+="　　　　"+mails.mail[i]+"\n";           	
            }
            
            //表示
            label.text=text;
        }

        //セキュリティエラーイベントの処理
        private function securityErrorHandler(evt:SecurityErrorEvent):void {
            label.text="セキュリティエラー";
        }

        //IOエラーイベントの処理
        private function ioErrorHandler(evt:IOErrorEvent):void {
            label.text="IOエラー";
        }

        //ラベルの追加
        private function addLabel(text:String):TextField {
            var label:TextField=new TextField();
            addChild(label);
            label.text=text;
            label.autoSize=TextFieldAutoSize.LEFT;
            label.selectable=false;
            return label;
        }
    }
}