﻿package {
    import flash.display.*;
    import flash.events.*;
    import flash.net.*;
    import flash.system.*;
    import flash.text.*;

    //ネットからのテキストの読み込み
    public class URLLoaderEx extends Sprite {        
        //変数
        private var loader:URLLoader;//ローダー
        private var label:TextField; //ラベル

        //コンストラクタ
        public function URLLoaderEx() {
            //シフトJISの使用
            System.useCodePage=true;

            //ラベルの追加
            label=addLabel("URLLoaderEx");

            //URLローダーの生成
            loader=new URLLoader();
            
            //リスナーの追加
            loader.addEventListener(ProgressEvent.PROGRESS,progressHandler);
            loader.addEventListener(Event.COMPLETE,completeHandler);
            loader.addEventListener(SecurityErrorEvent.SECURITY_ERROR,securityErrorHandler);
            loader.addEventListener(IOErrorEvent.IO_ERROR,ioErrorHandler);
                        
            //読み込み開始
            loader.load(new URLRequest("sample.txt"));
        }

        //読み込み中イベントの処理
        private function progressHandler(evt:ProgressEvent):void {
            label.text="読み込み中:"+loader.bytesLoaded+"/"+loader.bytesTotal;
        }

        //読み込み完了イベントの処理
        private function completeHandler(evt:Event):void {
            label.text=loader.data;
        }

        //セキュリティエラーイベントの処理
        private function securityErrorHandler(evt:SecurityErrorEvent):void {
            label.text="セキュリティエラー";
        }

        //IOエラーイベントの処理
        private function ioErrorHandler(evt:IOErrorEvent):void {
            label.text="IOエラー";
        }

        //ラベルの追加
        private function addLabel(text:String):TextField {
            var label:TextField=new TextField();
            addChild(label);
            label.text=text;
            label.autoSize=TextFieldAutoSize.LEFT;
            label.selectable=false;
            return label;
        }
    }
}