package {
    import flash.display.*;
    import flash.events.*;
    import flash.utils.*;
    
    //タイマーを使用する
    public class TimerEx extends Sprite {
        //素材クラスの定義
        [Embed(source='sample.swf')]
        private var Sample:Class;

        //変数
        private var sprite:Sprite;//素材オブジェクト
        private var vx:int=2;     //X速度
        private var vy:int=2;     //Y速度

        //コンストラクタ
        public function TimerEx() {
            //素材オブジェクトの生成
            sprite=new Sample();
            sprite.x=120;
            sprite.y=120;
            addChild(sprite);

            //タイマーの生成
            var timer:Timer=new Timer(50,0);
            
            //イベントリスナーの追加
            timer.addEventListener(TimerEvent.TIMER,onTick);
            
            //タイマーの開始
            timer.start();
        }

        //タイマーイベントの処理
        private function onTick(evt:TimerEvent):void {
            sprite.x+=vx;//X座標
            sprite.y+=vy;//Y座標
            sprite.rotation=(sprite.rotation+2)%360;//回転
            if (sprite.x<0 || 240<sprite.x) vx=-vx; //X反転
            if (sprite.y<0 || 240<sprite.y) vy=-vy; //Y反転
        }
    }
}