﻿package {
    import flash.display.*;
    import flash.events.*;
    import flash.media.*;
    import flash.text.*;

    //サウンドの再生
    public class SoundEx extends Sprite {
        //素材クラスの定義
        [Embed(source='sample.mp3')]
        private var Sample:Class;

        //変数
        private var sound:Sound;         //サウンド
        private var channel:SoundChannel;//チャンネル

        //コンストラクタ
        public function SoundEx() {
            //素材オブジェクトの生成
            sound=new Sample();

            //クリック対象となるスプライトの追加
            var base:Sprite=new Sprite();
            addChild(base);
            base.graphics.beginFill(0xffffff);
            base.graphics.drawRect(0,0,240,240);
            base.graphics.endFill();

            //ラベルの追加
            base.addChild(makeLabel("SoundEx"));
            
            //イベントリスナーの指定
            base.addEventListener(MouseEvent.CLICK,clickHandler);
        }

        //マウスクリックイベントの処理
        private function clickHandler(evt:MouseEvent):void {
            //サウンドの再生開始
            if (channel==null) {
                channel=sound.play();
            } 
            //サウンドの再生停止
            else {
                channel.stop();
                channel=null;
            }
        }

        //ラベルの追加
        private function makeLabel(text:String):TextField {
            var label:TextField=new TextField();
            label.text=text;
            label.autoSize=TextFieldAutoSize.LEFT;
            label.selectable=false;
            return label;
        }
    }
}