import java.io.*;
import java.net.*;
import java.util.*;

//`bgT[oXbh
public class ChatServerThread extends Thread { 
    private static List<ChatServerThread> threads=
        new ArrayList<ChatServerThread>();//XbhS
    private Socket socket;//\Pbg

    // RXgN^
    public ChatServerThread(Socket socket) {
        super();
        this.socket=socket;
        threads.add(this);
    }

    //
    public void run() {
        InputStream in =null;
        String message;
        int size;
        byte[] w=new byte[10240];
        try {
            //Xg[
            in =socket.getInputStream();
            while(true) {
                try {
                    //M҂
                    size=in.read(w);

                    //ؒf
                    if (size<=0) throw new IOException();

                    //ǂݍ
                    message=new String(w,0,size,"UTF8");
                    
                    //SɃbZ[WM
                    sendMessageAll(message);
                } catch (IOException e) {
                    socket.close();
                    threads.remove(this);
                    return;
                }
            }
        } catch (IOException e) {
            System.err.println(e);
        }
    }

    //SɃbZ[WM
    public void sendMessageAll(String message) {
        ChatServerThread thread;
        for (int i=0;i<threads.size();i++) {
            thread=(ChatServerThread)threads.get(i);
            if (thread.isAlive()) thread.sendMessage(this,message);
        }
        System.out.println(message);
    }

    //bZ[WM
    public void sendMessage(ChatServerThread talker,String message){
        try {
            OutputStream out=socket.getOutputStream();
            byte[] w=message.getBytes("UTF8");
            out.write(w);
            out.flush();
        } catch (IOException e) {
        }
    }
}