﻿package {
    import flash.display.*;
    import flash.events.*;
    import flash.text.*;
    import flash.net.*;
   
    //ローカルの保存領域にデータ保存する
    public class SharedObjectEx extends Sprite {
        private var textField:TextField;//テキストフィールド
        private var so:SharedObject;    //共有オブジェクト
        
        //コンストラクタ
        public function SharedObjectEx() {
            //クリック対象となるスプライトの追加
            var base:Sprite = new Sprite();
            base.graphics.beginFill(0xFFFFFF);
            base.graphics.drawRect(0,0,240,240);
            base.graphics.endFill();
            addChild(base);

            //テキストフィールドの追加
            textField=addTextField(base,"",10,10);

            //書き込みボタンの追加
            var btnWrite:CustomButton=new CustomButton("書き込み",12);
            btnWrite.x=10;
            btnWrite.y=40;
            btnWrite.addEventListener(MouseEvent.MOUSE_DOWN,writeHandler);
            base.addChild(btnWrite);

            //受信ボタンの追加
            var btnRead:CustomButton=new CustomButton("読み込み",12);
            btnRead.x=70;
            btnRead.y=40; 
            btnRead.addEventListener(MouseEvent.MOUSE_DOWN,readHandler);
            base.addChild(btnRead);

            //共有オブジェクトの取得
            so=SharedObject.getLocal("SharedObjectEx");
            if (so.data.text!=null) textField.text=so.data.text;            
        }

        //テキストフィールドの追加
        private function addTextField(doc:DisplayObjectContainer,
            text:String,x:int,y:int):TextField {
            var textField:TextField=new TextField();
            doc.addChild(textField);
            textField.x         =x;
            textField.y         =y;
            textField.width     =200;
            textField.height    =20;
            textField.text      =text;
            textField.selectable=true;
            textField.border    =true;
            textField.type      =TextFieldType.INPUT;
            return textField;
        }

        //ローカルの保存領域へのデータの書き込み
        private function writeHandler(evt:MouseEvent):void {
            so.data.text=textField.text;
            so.flush();
        }
        
        //ローカルの保存領域からデータの読み込み
        private function readHandler(evt:MouseEvent):void {
            if (so.data.text!=null) textField.text=so.data.text;            
        }
    }
}