package {
    import flash.display.*;
    import flash.filters.*;
    import flash.text.*;

    //カスタムボタン
    public class CustomButton extends SimpleButton {

        //コンストラクタ    
        public function CustomButton(label:String="",fontSize:uint=12) {
            //ボタンスプライト
            var downSprite:Sprite=makeButtonSprite(
                label,fontSize,0x000000,0xdddddd);
            var upSprite  :Sprite=makeButtonSprite(
                label,fontSize,0xdddddd,0x000000);
            var hitSprite :Sprite=makeButtonSprite(
                label,fontSize,0x000000,0x000000);
          
            //状態            
            downState   =downSprite;//ダウン
            overState   =upSprite;  //オーバー
            upState     =upSprite;  //アップ
            hitTestState=hitSprite;//当たり判定

            //手アイコンを指定
            useHandCursor=true;
        }
        
        //ボタンスプライトの生成
        private function makeButtonSprite(text:String,fontSize:uint,
            highlightColor:uint,shadowColor:uint):Sprite {
            //スプライト
            var sp:Sprite=new Sprite();
            //ラベルの指定
            var label:TextField=makeLabel(text,fontSize);
            //描画
            sp.graphics.beginFill(0xdddddd);
            sp.graphics.drawRect(0,0,
                label.textWidth+6,label.textHeight+6);
            sp.graphics.endFill();
            sp.addChild(label);
            //フィルタの指定
            var filter:BevelFilter=new BevelFilter();
            filter.blurX=2;
            filter.blurY=2;
            filter.distance=1;
            filter.highlightColor=highlightColor;
            filter.shadowColor=shadowColor;
            var myFilters:Array=new Array();
            myFilters.push(filter);
            sp.filters=myFilters; 
            return sp;         
        }

        //ラベルの生成
        private function makeLabel(text:String,fontSize:uint):TextField {
            var i:uint;
            var label:TextField=new TextField();
            label.autoSize=TextFieldAutoSize.LEFT;
            label.selectable=false;
            var format:TextFormat=new TextFormat();
            format.font="_等幅";
            label.text="■";
            for (i=fontSize+10;i>=1;i--) {
                format.size=i;
                label.setTextFormat(format);
                if (label.textWidth<=fontSize) break;
            }
            label.text=text;
            label.setTextFormat(format);
            label.x=3-(label.width -label.textWidth)/2;
            label.y=3-(label.height-label.textHeight)/2; 
            return label;
        } 
    }
}