package {
    import flash.display.*;
    
    //図形を表示する
    public class ShapeEx extends Sprite {
        //コンストラクタ
        public function ShapeEx() {
            //ラインの追加
            var line:Shape=makeLine(0,0,0,40,0xFF3333);
            addChild(line);
            line.x=25;
            line.y=5;

            //ポリラインの追加
            var plX:Array=[0,30,10,40,0];
            var plY:Array=[0,5,20,35,40];
            var polyline:Shape=makePolyline(plX,plY,0xFF3333);
            addChild(polyline);
            polyline.x=55;
            polyline.y=5;
    
            //矩形の追加
            var rect:Shape=makeRect(40,40,0x55FF55);
            addChild(rect);
            rect.x=5;
            rect.y=55;
            
            //角丸矩形の追加
            var rrect:Shape=makeRoundRect(40,40,20,0x55FF55);
            addChild(rrect);
            rrect.x=55;
            rrect.y=55;

            //円の追加
            var circle:Shape=makeCircle(20,0xFFFF55);
            addChild(circle);
            circle.x=125;
            circle.y=75;
        }
    
        //ラインの生成
        private function makeLine(x0:int,y0:int,x1:int,y1:int,color:uint):Shape {
            var line:Shape=new Shape();
            line.graphics.lineStyle(0,color);//線幅・線色
            line.graphics.moveTo(x0,y0);     //始点のXY座標
            line.graphics.lineTo(x1,y1);     //終点のXY座標
            return line
        }

        //ポリラインの生成
        private function makePolyline(x:Array,y:Array,color:uint):Shape {
            var i:int;
            var line:Shape=new Shape();
            line.graphics.lineStyle(0,color);   //線幅・線色
            line.graphics.moveTo(x[0],y[0]);    //始点のXY座標
            for (i=1;i<x.length;i++) {
                line.graphics.lineTo(x[i],y[i]);//頂点のXY座標
            }
            return line;
        }
    
        //矩形の生成
        private function makeRect(w:uint,h:uint,color:uint):Shape {
            var rect:Shape=new Shape();
            rect.graphics.lineStyle(0,0x000000);//線幅・線色
            rect.graphics.beginFill(color);     //塗り潰し色
            rect.graphics.drawRect(0,0,w,h);    //XY座標,幅,高さ
            rect.graphics.endFill();            //塗り潰し終了
            return rect;
        }
     
        //角丸矩形の生成
        private function makeRoundRect(w:uint,h:uint,ew:uint,color:uint):Shape {
            var rrect:Shape=new Shape();
            rrect.graphics.lineStyle(0,0x000000);    //線幅・線色
            rrect.graphics.beginFill(color);         //塗り潰し色
            rrect.graphics.drawRoundRect(0,0,w,h,ew);//XY座標,幅,高さ,角丸幅
            rrect.graphics.endFill();                //塗り潰し終了
            return rrect;
        }   
        
        //円の生成
        private function makeCircle(r:uint,color:uint):Shape {
            var circle:Shape=new Shape();
            circle.graphics.beginFill(color);     //背景色
            circle.graphics.lineStyle(0,0x000000);//線幅・線色
            circle.graphics.drawCircle(0,0,r);    //XY座標,半径
            circle.graphics.endFill();            //塗り潰し終了
            return circle;
        }        
    }
}