package {
    import flash.display.*;
    import flash.events.*;
    import flash.utils.*;
    
    //シューティングゲーム
    public class RedEye extends JCanvas {
        //リソースクラス
        [Embed(source='0.gif')]
        private var Image0:Class;
        [Embed(source='1.gif')]
        private var Image1:Class;
        [Embed(source='2.gif')]
        private var Image2:Class;
        [Embed(source='3.gif')]
        private var Image3:Class;

        //シーン定数
        private const S_PLAY:int=0;    //プレイ
        private const S_GAMEOVER:int=1;//ゲームオーバー
    
        //システム
        private var scene:int=S_PLAY;        //シーン
        private var init:int=S_PLAY;         //初期化
        private var keyEvent:int=-999;       //キーイベント
        private var image:Array=new Array(4);//イメージ
    
        //ウィング
        private var score:int;//スコア
        private var wingX:int;//X座標
        private var magic:int;//魔法(-1:無,他:発射)
    
        //生命体
        private var enemyType:Array=new Array(8);//種別(-1:無,0:赤,1:緑)
        private var enemyX:Array=new Array(8);   //X座標
        private var enemyY:Array=new Array(8);   //Y座標
    
        //隕石
        private var rockX:Array=new Array(8);//X座標
        private var rockY:Array=new Array(8);//Y座標

        //コンストラクタ
        public function RedEye() {
        	super(240,240);
            //イメージ
            image[0]=new Image0();
            image[1]=new Image1();
            image[2]=new Image2();
            image[3]=new Image3();

            //タイマー
            var timer:Timer=new Timer(100,0);
            timer.addEventListener(TimerEvent.TIMER,onTick);
            timer.start();
        }
        
        //タイマーイベントの処理
        private function onTick(evt:TimerEvent):void {
            var i:int;
            
            //シーンの初期化
            //--------------------
            if (init>=0) {
                //プレイ
                if (init==S_PLAY) {
                    score=0;
                    wingX=120;
                    for (i=0;i<8;i++) enemyType[i]=-1;
                    for (i=0;i<8;i++) {
                        rockX[i]=rand(240);
                        rockY[i]=rand(240);
                    }
                }
                //共通
                scene   =init;
                init    =-1;
                keyEvent=-999;
                magic   =-1;
            }

            //画面の描画
            //--------------------
            //背景の描画
            //g.lock();
            g.setColor(g.getColorOfRGB(200,140,0));
            g.fillRect(0,0,240,240);

            //隕石の描画
            for (i=0;i<8;i++) {
                g.drawImage(image[3],rockX[i]-20,rockY[i]-20);
            }

            //魔法の描画
            if (magic>=0) {
                g.setColor(g.getColorOfRGB(255,50,50));
                g.fillRect(wingX-3,210-magic,6,magic);
            }

            //生命体の描画
            for (i=0;i<8;i++) {
                if (enemyType[i]>=0) {
                    g.drawImage(image[enemyType[i]],
                        enemyX[i]-image[enemyType[i]].width/2,
                        enemyY[i]-image[enemyType[i]].height/2);
                }
            }

            //ウィングの描画
            if (scene==S_PLAY) {
                g.drawImage(image[2],wingX-20,210-20);
            }

            //スコアの描画
            g.setFontSize(12);
            drawBold("SCORE "+formatNum(score,6),158,20,
                g.getColorOfRGB(55,55,55),g.getColorOfRGB(255,255,255));

            //ゲームオーバーの描画
            if (scene==S_GAMEOVER) {
                g.setFontSize(24);
                drawBold("ゲームオーバー",(240-7*24)/2,90,
                    g.getColorOfRGB(255,0,0),
                    g.getColorOfRGB(255,120,120));
            }

            //ソフトキーの処理
            //--------------------
            if (scene==S_GAMEOVER) {
                if (keyEvent==Display.KEY_SELECT) init=S_PLAY;
            }

            //プレイの処理
            //--------------------
            if (scene==S_PLAY) {
                //生命体の遷移
                for (i=0;i<8;i++) {
                    //出現
                    if (enemyType[i]==-1) {
                        if (rand(70)==0) {
                            if (rand(6)!=0) {
                                enemyType[i]=0;
                            } else {
                                enemyType[i]=1;
                            }
                            enemyX[i]=40+rand(5)*40;
                            enemyY[i]=-30;
                        }
                    }
                    //移動
                    else {
                        //移動
                        enemyY[i]+=2;
                        if (enemyY[i]>240) init=S_GAMEOVER;

                        //ウィングの衝突判定
                        if (enemyX[i]-18<wingX && enemyX[i]+18>wingX &&
                            enemyY[i]-18<190   && enemyY[i]+18>190) {
                            init=S_GAMEOVER;
                        }

                        //魔法の衝突判定
                        if (magic>=0 &&
                            enemyX[i]-18<wingX     && enemyX[i]+18>wingX &&
                            enemyY[i]-30<210-magic && enemyY[i]+20>210-magic) {
                            magic=-1;
                            score+=10+enemyType[i]*90;
                            enemyType[i]=-1;
                        }
                    }
                }

                //隕石の遷移
                for (i=0;i<8;i++) {
                    rockY[i]+=10;
                    if (rockY[i]>260) {
                        rockX[i]=rand(240);
                        rockY[i]=-20-rand(240);
                    }
                }

                //ウィングの遷移
                if (magic>=0) {
                    //魔法
                    magic+=40;
                    if (magic>=250) magic=-1;
                } else {
                    //キーイベント
                    if (keyEvent==Display.KEY_LEFT) {
                        if (wingX>40) wingX-=40;
                    } else if (keyEvent==Display.KEY_RIGHT) {
                        if (wingX<200) wingX+=40;
                    } else if (keyEvent==Display.KEY_SELECT) {
                        magic=40;
                    }
                }
                keyEvent=-999;
            }
        };    

        //太文字の描画
        private function drawBold(text:String,x:int,y:int,col0:int,col1:int):void {
            g.setColor(col0);
            g.drawString(text,x-1,y-1);
            g.drawString(text,x  ,y-1);
            g.drawString(text,x+1,y-1);
            g.drawString(text,x-1,y);
            g.drawString(text,x+1,y);
            g.drawString(text,x-1,y+1);
            g.drawString(text,x  ,y+1);
            g.drawString(text,x+1,y+1);
            g.setColor(col1);
            g.drawString(text,x,y);
        }

        //数字フォーマットを整える
        private function formatNum(num:int,len:int):String {
            var str:String=""+num;
            while (str.length<len) str="0"+str;
            return str;
        }

        //キーイベントの処理
        public override function processEvent(type:int,param:int):void {
            if (type==Display.KEY_PRESSED_EVENT) keyEvent=param;
        }

        //乱数の取得
        private function rand(num:Number):Number {
            return Math.floor(Math.random()*num);
        }
    }
}