package {
    import flash.display.*;
    import flash.events.*;
    import flash.net.*;
    import flash.system.*;
    import flash.text.*;
    import flash.ui.*;
    import flash.utils.*;
    
    //ネットワークゲーム
    public class NetworkGame extends Sprite {
	    //シーン定数
	    private static const S_TITLE:int=0;//タイトル
	    private static const S_PLAY:int =1;//プレイ

		//マップ定数
		private static const MAP:Array=[
			[4,0,0,1,2,2,2,2,2,2,2,3,0,0,4],
			[4,5,5,5,5,5,5,5,5,5,5,5,5,5,4],
			[4,5,5,6,5,6,5,6,5,6,5,6,5,5,4],
			[4,5,5,5,5,5,5,5,5,5,5,5,5,5,4],
			[4,5,5,6,5,6,5,6,5,6,5,6,5,5,4],
			[4,5,5,5,5,5,5,5,5,5,5,5,5,5,4],
			[4,5,5,6,5,6,5,6,5,6,5,6,5,5,4],
			[4,5,5,5,5,5,5,5,5,5,5,5,5,5,4],
			[4,4,4,4,4,4,4,4,4,4,4,4,4,4,4]];

        //素材クラス
        [Embed(source='0.png')]
        private var Image0:Class;
        [Embed(source='1.png')]
        private var Image1:Class;
        [Embed(source='2.png')]
        private var Image2:Class;
        [Embed(source='3.png')]
        private var Image3:Class;
        [Embed(source='4.png')]
        private var Image4:Class;
        [Embed(source='5.png')]
        private var Image5:Class;
        [Embed(source='6.png')]
        private var Image6:Class;

        //素材オブジェクト
        private var image:Array =new Array(7);

        //システム
        private var init:int =S_TITLE;  //初期化
        private var scene:int=S_TITLE;  //シーン
        private var base:Sprite;        //クリック対象
        private var g:JGraphics;        //グラフィックス
        private var textField:TextField;//テキストフィールド 
               
        //キャラクター
        private var player:Character=new Character();//プレイヤー
        private var other:Array=new Array();         //他人

        //コンストラクタ
        public function NetworkGame() {
			//シフトJISの使用
			System.useCodePage=true;
			
            //素材オブジェクトの生成
            image[0]=new Image0();
            image[1]=new Image1();
            image[2]=new Image2();
            image[3]=new Image3();
            image[4]=new Image4();
            image[5]=new Image5();
            image[6]=new Image6();

            //クリック対象
            base=new Sprite();
            base.graphics.beginFill(0x000000);
            base.graphics.drawRect(0,0,640,480);
            base.graphics.endFill();
            addChild(base);

        	//JGraphicsオブジェクトの生成
        	g=new JGraphics(640,432);
        	
        	//Bitmapオブジェクトの追加
            base.addChild(new Bitmap(g.getBitmapData()));

            //テキストフィールドの生成
            textField=Util.makeTextField("",8,440,624,20);
            base.addChild(textField);
            textField.addEventListener(KeyboardEvent.KEY_DOWN,keyDownHandler);

            //イベントリスナーの追加
            base.addEventListener(MouseEvent.CLICK,clickHandler); 

            //タイマーの追加
            var timer:Timer=new Timer(50,0);
            timer.addEventListener(TimerEvent.TIMER,onTick);
            timer.start();
        }

        //タイマーイベントの処理
        private function onTick(evt:TimerEvent):void {
        	var i:int,j:int;

            //シーンの初期化
            if (init>=0) {
            	//プレイの初期化
            	if (init==S_PLAY) {
            		//通信タイマーの追加
            		var timer:Timer=new Timer(2000,1);
        		    timer.addEventListener(TimerEvent.TIMER,onNet);
		            timer.start();            		
            	}
            	//共通の初期化
                scene=init;
                init =-1;
            }

			//背景の描画			
			for (j=0;j<9;j++) {
				for (i=0;i<16;i++) {
					g.drawImage(image[MAP[j][i]],i*48-40,j*48);
				}
			}
			
			//キャラクターの描画
			for (i=0;i<other.length;i++) other[i].draw(g);
			player.draw(g);

            //タイトルの描画
            if (scene==S_TITLE) {
	            g.setColor(g.getColorOfRGB(255,255,255));
	            g.setFontSize(20);
	            g.drawString("ハルハレオンライン",
	            	(640-g.stringWidth("ハルハレオンライン"))/2,24);
            }
        }

        //キーダウンイベントの処理
        private function keyDownHandler(evt:KeyboardEvent):void {
            if (evt.keyCode==Keyboard.ENTER) {          
	            player.setSerif(textField.text);
	            textField.text="";
	        }
        }

        //マウスクリックイベントの処理
        private function clickHandler(evt:MouseEvent):void {
        	if (base.mouseY>432) return; 
            if (scene==S_TITLE) init=S_PLAY;
            if (scene==S_PLAY) {          
	            player.setToXY(base.mouseX,base.mouseY);
	        }
        }

	    //定期通信イベントの処理
	    private function onNet(evt:TimerEvent):void {
			readText("http://localhost:8080/NetworkGame/world.jsp"+
				player.getInfo());
	    }

	    //テキストを読み込む
	    private function readText(url:String):void {
	    	trace(url);
	        var request:URLRequest=new URLRequest(url);
	        var loader:URLLoader=new URLLoader();
	        loader.addEventListener(Event.COMPLETE,completeHandler);
            loader.addEventListener(SecurityErrorEvent.SECURITY_ERROR,securityErrorHandler);
            loader.addEventListener(IOErrorEvent.IO_ERROR,ioErrorHandler);
	        loader.load(request);
	    }
	
	    //完了イベントの処理
	    private function completeHandler(evt:Event):void {
			var i:int;
	        var loader:URLLoader=URLLoader(evt.target);
	        if (loader.data==null) return;
	        trace(loader.data);
	        
	        //削除フラグ
	        for (i=0;i<other.length;i++) other[i].setDelFlag(true);

			//情報の解析
			var line:Array=Util.parseString(loader.data,'\n');
			for (i=0;i<line.length;i++) {
				var info:Array=Util.parseString(line[i],',');
	    		if (info.length<6) continue;

    			//IDの取得
    			var id:int=parseInt(info[0]);
    			
    			//プレイヤー情報はキャンセル
    			if (id==player.getID()) continue;

    			//他人キャラクターの取得
    			var o:Character=searchOther(id);

    			//他人キャラクターの追加
    			if (o==null) {
    				o=new Character();
    				o.setInfo(info,true);
    				other.push(o);    				
    			}

    			//他人キャラクターの更新
    			else {
    				o.setInfo(info);
    			}
	   		}
	   		
	   		//削除
	   		for (i=other.length-1;i>=0;i--) {
	   			if (other[i].getDelFlag()) other.splice(i,1);
	   		}

            //タイマーの追加
            var timer:Timer=new Timer(2000,1);
            timer.addEventListener(TimerEvent.TIMER,onNet);
            timer.start();
	    }

        //セキュリティエラーイベントの処理
        private function securityErrorHandler(evt:SecurityErrorEvent):void {
            navigateToURL(new URLRequest(
           		"javascript:alert(\"セキュリティエラー\");"),"_self");
        }

        //IOエラーイベントの処理
        private function ioErrorHandler(evt:IOErrorEvent):void {
            navigateToURL(new URLRequest(
           		"javascript:alert(\"通信エラー\");"),"_self");
        }
	    
	    //他人キャラクターの検索
	    public function searchOther(id:int):Character {
	    	var i:int;
	    	for (i=0;i<other.length;i++) {
	    		if (other[i].getID()==id) return other[i];
	    	}	
	    	return null;
	    }
    }
}
