package {
    import flash.display.*;
    import flash.events.*;
    import flash.net.*;
    import flash.text.*;
    
    //ネットから画像を読み込む
    public class LoaderEx extends Sprite {
        //変数
        private var label:TextField;//ラベル
        private var rect:Shape;     //矩形

        //コンストラクタ
        public function LoaderEx() {
            //ラベルの追加
            label=addLabel("LoaderEx");

            //矩形の追加
            rect=addRect(10,10,0xFF0000);
            rect.x=0;
            rect.y=20;

            //ローダーの生成
            var loader:Loader=new Loader();
            loader.x=120;
            loader.y=120;
            addChild(loader);

			//イベントリスナーの追加
            with(loader.contentLoaderInfo) {
	            addEventListener(ProgressEvent.PROGRESS,progressHandler);
	            addEventListener(Event.COMPLETE,completeHandler);
                addEventListener(SecurityErrorEvent.SECURITY_ERROR,securityErrorHandler);
	            addEventListener(IOErrorEvent.IO_ERROR,ioErrorHandler);
            }
            
            //読み込み開始
            loader.load(new URLRequest("sample.swf"));
        }

        //プログレスイベントの処理
        private function progressHandler(evt:ProgressEvent):void {
        	var rate:int=Math.floor((evt.bytesLoaded*100)/evt.bytesTotal);
            label.text="読み込み中:"+rate+"%";
            rect.width=rate*2.4;
        }

        //読み込み完了イベントの処理
        private function completeHandler(evt:Event):void {
            label.text="読み込み完了";
            rect.visible=false;
        }

        //セキュリティエラーイベントの処理
        private function securityErrorHandler(evt:SecurityErrorEvent):void {
            label.text="セキュリティエラー";
        }

		//IOエラーイベントの処理
        private function ioErrorHandler(evt:IOErrorEvent):void {
            label.text="IOエラー";
        }

        //ラベルの追加
        private function addLabel(text:String):TextField {
            var label:TextField=new TextField();
            addChild(label);
            label.text=text;
            label.autoSize=TextFieldAutoSize.LEFT;
            label.selectable=false;
            return label;
        }

        //矩形の生成
        private function addRect(w:uint,h:uint,color:uint):Shape {
            var rect:Shape=new Shape();
            addChild(rect);
            rect.graphics.lineStyle(0,0x000000);//線幅・線色
            rect.graphics.beginFill(color);     //塗り潰し色
            rect.graphics.drawRect(0,0,w,h);    //XY座標,幅,高さ
            rect.graphics.endFill();            //塗り潰し終了
            return rect;
        }
    }
}