package {
    import flash.display.*;
    import flash.events.*;
    import flash.text.*;
    import flash.ui.*;
    
    //キーイベントを処理する 
    public class KeyEx extends Sprite {
        private var base:Sprite;    //キー入力対象となるスプライト
        private var label:TextField;//ラベル

        //コンストラクタ
        public function KeyEx() {
            //キー入力対象となるスプライト
            base=new Sprite();
            base.graphics.beginFill(0xFFFFFF);
            base.graphics.drawRect(0,0,240,240);
            base.graphics.endFill();
            base.focusRect=false;
            addChild(base);

            //ラベルの追加
            label=makeLabel("キーイベント");
            base.addChild(label);
            
            //イベントリスナーの追加
            base.addEventListener(KeyboardEvent.KEY_DOWN,keyDownHandler);
            base.addEventListener(KeyboardEvent.KEY_UP,keyUpHandler);
            base.addEventListener(MouseEvent.CLICK,clickHandler);  
        }

        //キーダウンイベントの処理
        private function keyDownHandler(evt:KeyboardEvent):void {
            var text:String="";
            text+="キーダウン\n";
            text+="キーコード："      +evt.keyCode+"\n";
            text+="コントロールキー："+evt.ctrlKey+"\n";
            text+="シフトキー："      +evt.shiftKey+"\n";
            text+="Alt/optionキー："      +evt.altKey+"\n";
            label.text=text;
        }

        //キーアップイベントの処理
        private function keyUpHandler(evt:KeyboardEvent):void {
            var text:String="";
            text+="キーアップ\n";
            text+="キーコード："      +evt.keyCode+"\n";
            text+="コントロールキー："+evt.ctrlKey+"\n";
            text+="シフトキー："      +evt.shiftKey+"\n";
            text+="Alt/optionキー："      +evt.altKey+"\n";
            label.text=text;
        }

        //マウスクリックイベントの処理
        private function clickHandler(evt:MouseEvent):void {
            //キー入力対象となるスプライトにフォーカス
            stage.focus=base;
        }

        //ラベルの生成
        private function makeLabel(text:String):TextField {
            var label:TextField=new TextField();
            label.text=text;
            label.autoSize=TextFieldAutoSize.LEFT;
            label.selectable=false;
            return label;
        }
    }
}