﻿package {
    import flash.display.*;
    import flash.events.*;
    import flash.system.*;
    import flash.text.*;
   
    //IME制御を行う
    public class IMEEx extends Sprite {
        private var tfName:TextField;//名前
        private var tfMail:TextField;//メール
        
        //コンストラクタ
        public function IMEEx() {
            //ラベルの追加
            addLabel("名前",10,10);
            addLabel("メール",10,40);

            //テキストフィールドの追加
            tfName=addTextField("",50,10);
            tfMail=addTextField("",50,40);

			//イベントリスナーの追加
            tfName.addEventListener(FocusEvent.FOCUS_IN,focusInHandler);            
            tfMail.addEventListener(FocusEvent.FOCUS_IN,focusInHandler);            
        }

        //ラベルの追加
        private function addLabel(text:String,x:int,y:int):TextField {
            var label:TextField=new TextField();
            label.autoSize=TextFieldAutoSize.LEFT;
            label.text=text;
            label.x=x;
            label.y=y;
            addChild(label);   
            return label;     
        }

        //テキストフィールドの追加
        private function addTextField(text:String,x:int,y:int):TextField {
            var textField:TextField=new TextField();
            textField.width     =160;
            textField.height    =20;
            textField.text      =text;
            textField.selectable=true;
            textField.border    =true;
            textField.type      =TextFieldType.INPUT;
            textField.x         =x;
            textField.y         =y;
            addChild(textField); 
            return textField;       
        }

        //フォーカスインイベントの処理
        private function focusInHandler(evt:FocusEvent):void {
            //名前にフォーカス
            if (evt.target==tfName) {
                IME.conversionMode=IMEConversionMode.JAPANESE_HIRAGANA;
            } 
            //メールにフォーカス
            if (evt.target==tfMail) {
                IME.conversionMode=IMEConversionMode.ALPHANUMERIC_HALF;
            }
        }
    }
}