package {
    import flash.display.*;
    import flash.events.*;
    import flash.external.*;
    import flash.net.*;
    import flash.text.*;
    import flash.ui.*;
    
    //ダイアログを表示する 
    public class DialogEx extends Sprite {
        private var base:Sprite;          //キー入力対象となるスプライト
        private var label:TextField;      //ラベル
		private var confirmText:String="";//選択テキスト
		private var promptText:String ="";//入力テキスト

        //コンストラクタ
        public function DialogEx() {
            //キー入力対象となるスプライト
            base=new Sprite();
            base.graphics.beginFill(0xFFFFFF);
            base.graphics.drawRect(0,0,240,240);
            base.graphics.endFill();
            addChild(base);

            //ラベルの追加
            label=makeLabel("");
            draw();
            base.addChild(label);
            
            //イベントリスナーの追加
            base.addEventListener(KeyboardEvent.KEY_DOWN,keyDownHandler);
            base.addEventListener(MouseEvent.CLICK,clickHandler);  

			//外部インタフェースの追加
            if (ExternalInterface.available) {
                ExternalInterface.addCallback("setConfirmResult",setConfirmResult);
                ExternalInterface.addCallback("setPromptResult",setPromptResult);
            }
        }
        
        //描画
        private function draw():void {
            label.text=
                "1キー:警告ダイアログの表示\n"+
                "\n"+
            	"2キー:選択ダイアログの表示\n"+
                "    結果["+confirmText+"]\n"+
            	"3キー:入力ダイアログの表示\n"+
                "    結果["+promptText+"]";        	
        }

		//選択ダイアログの結果の受信
        private function setConfirmResult(value:String):void {
        	confirmText=value;
        	draw();
        }

		//入力ダイアログの結果の受信
        private function setPromptResult(value:String):void {
        	promptText=value;
        	draw();
        }

        //キーダウンイベントの処理
        private function keyDownHandler(evt:KeyboardEvent):void {
            if (evt.keyCode==49 || evt.keyCode==97) {       //1キー  
            	navigateToURL(new URLRequest(
            		"javascript:alert(\"警告ダイアログのテキストを表示\");"),"_self");    
            } else if (evt.keyCode==50 || evt.keyCode==98) {//2キー           	
            	ExternalInterface.call("showConfirm","選択ダイアログのテキストを表示");
            } else if (evt.keyCode==51 || evt.keyCode==99) {//3キー           	
            	ExternalInterface.call("showPrompt","入力ダイアログのテキストを表示");
            }
        }

        //マウスクリックイベントの処理
        private function clickHandler(evt:MouseEvent):void {
            //キー入力対象となるスプライトにフォーカス
            stage.focus=base;
        }

        //ラベルの生成
        private function makeLabel(text:String):TextField {
            var label:TextField=new TextField();
            label.text=text;
            label.autoSize=TextFieldAutoSize.LEFT;
            label.selectable=false;
            return label;
        }
    }
}