package {
    import flash.display.*;
    import flash.geom.*
    import flash.text.*;
    
    //簡単なラスタ描画が可能になるクラス
    public class JGraphics {
        //色定数
        public static const 
        	AQUA:uint   =(  0<<16)+(255<<8)+255,//水色
        	BLACK:uint  =(  0<<16)+(  0<<8)+  0,//黒
	        BLUE:uint   =(  0<<16)+(  0<<8)+255,//青
	        FUCHSIA:uint=(255<<16)+(  0<<8)+255,//紫
	        GRAY:uint   =(128<<16)+(128<<8)+128,//灰
	        GREEN:uint  =(  0<<16)+(128<<8)+  0,//暗い緑
	        LIME:uint   =(  0<<16)+(255<<8)+  0,//緑
	        MAROON:uint =(128<<16)+(  0<<8)+  0,//暗い赤
	        NAVY:uint   =(  0<<16)+(  0<<8)+128,//暗い青
	        OLIVE:uint  =(128<<16)+(128<<8)+  0,//暗い黄
	        PURPLE:uint =(128<<16)+(  0<<8)+128,//暗い紫
	        RED:uint    =(255<<16)+(  0<<8)+  0,//赤
	        SILVER:uint =(192<<16)+(192<<8)+192,//銀
	        TEAL:uint   =(  0<<16)+(128<<8)+128,//暗い水色
	        WHITE:uint  =(255<<16)+(255<<8)+255,//白
	        YELLOW:uint =(255<<16)+(255<<8)+  0;//黄

        //変数
        private var bd:BitmapData;    //BMPデータ
        private var color:uint;       //色
        private var label:TextField;  //ラベル
        private var format:TextFormat;//フォーマット

        //コンストラクタ
        public function JGraphics(w:uint,h:uint) {           
            //BMPデータ
            bd=new BitmapData(w,h,false,0xffffff);
            //色
            color=0x000000; 
            //ラベル
            label=new TextField();
            label.autoSize=TextFieldAutoSize.LEFT;
            //フォーマット
            format=new TextFormat();
            format.font ="_等幅";
            format.color=0x000000;
            setFontSize(12);
        }
        
        //BMPデータの取得
        public function getBitmapData():BitmapData {
            return bd;
        }

        //ピクセル単位でのフォントサイズの指定
        public function setFontSize(size:int):void {
            var i:uint;
            label.text="■";
            for (i=size+10;i>=1;i--) {
                format.size=i;
                label.setTextFormat(format);
                if (label.textWidth<=size) break;
            }           
        }        

        //文字列幅の取得
        public function stringWidth(text:String):int {
            label.text=text;
            label.setTextFormat(format);
            return label.textWidth; 
        }

        //文字列高さの取得
        public function stringHeight(text:String):int {
            label.text=text;
            label.setTextFormat(format);
            return label.textHeight; 
        }
        
        //色の指定
        public function setColor(color:uint):void {
            this.color=color;
            format.color=color;
        }

        //色の取得
        public function getColorOfRGB(r:uint,g:uint,b:uint):uint {
            return (r<<16)+(g<<8)+b;
        }
        
        //色の取得
        public function getColorOfName(name:uint):uint {
            return name;
        }        
        
        //塗り潰し矩形の描画
        public function fillRect(x:int,y:int,w:uint,h:uint):void {
            bd.fillRect(new Rectangle(x,y,w,h),color);
        }        
        
        //ラインの描画
        public function drawLine(x0:int,y0:int,x1:int,y1:int):void {
            var line:Shape=new Shape();
            line.graphics.lineStyle(0,color);
            line.graphics.moveTo(x0,y0);
            line.graphics.lineTo(x1,y1);
            bd.draw(line);
        }

        //矩形の描画
        public function drawRect(x:int,y:int,w:int,h:int):void {
            var line:Shape=new Shape();
            line.graphics.lineStyle(0,color);
            line.graphics.moveTo(x,y);
            line.graphics.lineTo(x+w,y);
            line.graphics.lineTo(x+w,y+h);
            line.graphics.lineTo(x,y+h);
            line.graphics.lineTo(x,y);
            bd.draw(line);
        }
        
        //文字列の描画
        public function drawString(text:String,x:int,y:int):void {
            if (text==null) return;
            label.text=text;
            label.setTextFormat(format);
            var pos:Matrix=new Matrix();
            pos.translate(
                x-(label.width -label.textWidth)/2,
                y-(label.height-label.textHeight)/2-label.textHeight);
            bd.draw(label,pos);     
        }
        
        //イメージの描画
        public function drawImage(source:IBitmapDrawable,x:int,y:int):void {
            if (source==null) return;
            var pos:Matrix=new Matrix();
            pos.translate(x,y);
            bd.draw(source,pos);
        }
    }
}
