require 'rubygems'
require 'rubyclr'

RubyClr::reference 'System.Data'
RubyClr::reference 'System.Drawing'
RubyClr::reference 'System.Windows.Forms'

include System
include System::Data
include System::Windows::Forms

module WinFormsApp
  def self.run klass
    Application.enable_visual_styles
    Application.set_compatible_text_rendering_default false
    Application.run(klass.new.form)
  end  
end

class MainForm
  attr_reader :form
  def initialize
    form      = Form.new
    form.text = 'Ruby App'
    
    label = Label.new 
    label.text = "Hello! RubyCLR!"
    form.controls.add(label)
    @form = form
  end
end

WinFormsApp.run MainForm
