require 'rubygems'
require 'rubyclr'

class InlineDemo
  inline :csharp do |compiler|
    compiler.compile <<CSHARP
    using System;
    namespace RubyClr {
      public class DisposeDemo : IDisposable {
          public DisposeDemo(){
            Console.WriteLine("now constructing");
          }
          public void Dispose(){
            Console.WriteLine("now disposing");
          }
      }
   }
CSHARP
  end

  def self.auto_dispose_demo
    auto_dispose(DisposeDemo.new) do |dispose_demo|
      puts "now in block"
      sleep 1
    end
    puts "exited block"
  end
end

InlineDemo.auto_dispose_demo
