require 'rubygems'
require 'rubyclr'

require 'rubygems'
require 'rubyclr'

RubyClr::reference 'System.Data'
RubyClr::reference 'System.Drawing'
RubyClr::reference 'System.Windows.Forms'

include System
include System::Data
include System::Windows::Forms

module WinFormsApp
  def self.run klass
    Application.enable_visual_styles
    Application.set_compatible_text_rendering_default false
    Application.run(klass.new.form)
  end  
end

class MainForm
  attr_reader :form
  def initialize
    @count = 0

    form      = Form.new
    form.text = 'Ruby App'
    
    button = Button.new
    button.Text = "click!"
    button.click do |sender,arg|
      @count += 1
      button.Text = "click #{@count} !"
    end

    form.controls.add(button)

    @form = form
  end
end

WinFormsApp.run MainForm
