require 'rubygems'
require 'rubyclr'

def inspect_enum type
  clr_type = type.clr_type
  enums = Enum.get_values type.clr_type
  array = []
  0.upto(enums.length-1) do |i|
    array << "#{enums[i].to_s}=#{enums[i].to_i}"
  end
  "#{clr_type.full_name} of #{clr_type.enum_type.full_name} <#{array.join(",")}>"
end

puts inspect_enum(System::PlatformID)
platform = Environment.OSVersion.Platform
if platform.clr_type.is_enum?
  puts "Current System is #{platform.to_s} #{platform.to_i}"
end
