#!/usr/bin/ruby

require 'rjb'
require 'webrick'

Rjb::load("poi.jar")

FileInputStream = Rjb::import("java.io.FileInputStream")
POIFSFileSystem = Rjb::import("org.apache.poi.poifs.filesystem.POIFSFileSystem")
 HSSFWorkbook = Rjb::import("org.apache.poi.hssf.usermodel.HSSFWorkbook")
 ByteArrayOutputStream = Rjb::import("java.io.ByteArrayOutputStream")

 class Workbook
   def initialize filename
     fin = FileInputStream.new filename
     poifs = POIFSFileSystem.new fin
     @workbook = HSSFWorkbook.new poifs
   end

   def write out
     @workbook.write(out)
   end

   def to_string
     baos = ByteArrayOutputStream.new
     write baos
     bytes = baos.toByteArray
     return bytes.to_s
   end
 end

 class ExcelServlet < WEBrick::HTTPServlet::AbstractServlet
   def do_GET(req, res)
     w = Workbook.new "poi-after.xls"
     res['Content-Type'] = "application/vnd.ms-excel"
     res.body = w.to_string
   end
 end

 s = WEBrick::HTTPServer.new( :Port => 2000 )
 s.mount("/poi", ExcelServlet)

 trap("INT"){ s.shutdown }
 s.start

