require 'rubygems'
require 'rjb'

module Iterable
  def each
    iter = self.iterator
    while iter.hasNext
      yield iter.next
    end
  end
end

ArrayList = Rjb::import("java.util.ArrayList")
Collections = Rjb::import("java.util.Collections")

a = ArrayList.new
a.add 1
a.add 10
a.add 5
puts a.get(1)._classname

Collections.sort(a)

a.extend Iterable
a.each do |i|
  puts i.intValue
end
