require 'win32ole'

def get_absolute_name filename
  fso = WIN32OLE.new("Scripting.FileSystemObject")
  abs_path = fso.GetAbsolutePathName(filename)
  return abs_path
end

def main
  filename = "sample1.wav"
  name = "Tv"
  album = "sample album name"
  artist = "sample artist name"

  itunes = WIN32OLE.new("iTunes.Application")
  abs_path = get_absolute_name(filename)
  puts "start to convert #{abs_path} ..."
  status = itunes.ConvertFile(abs_path)
  WIN32OLE_EVENT.message_loop while status.InProgress
  puts "finish converting #{abs_path} ..."

  track = nil
  status.Tracks.each do |t|
    track = t
    break
  end

  track.Name = name
  track.Album = album
  track.Artist = artist
end

if $0 == __FILE__
  main
end
