require 'win32ole'

def main
  filename = "sample1.wav"
  itunes = WIN32OLE.new("iTunes.Application")
  track = import_file itunes, filename
  m4a_filename = track.Location
  m4b_filename = move_file m4a_filename

  track.Delete
  status2 = itunes.LibraryPlaylist.AddFile(m4b_filename)
  WIN32OLE_EVENT.message_loop while status2.InProgress
end

def get_absolute_name filename
  fso = WIN32OLE.new("Scripting.FileSystemObject")
  abs_path = fso.GetAbsolutePathName(filename)
  return abs_path
end

def move_file filename
  fso = WIN32OLE.new("Scripting.FileSystemObject")
  dir = fso.GetParentFolderName(filename)
  basename = fso.GetBaseName(filename)
  m4b_filename = fso.BuildPath(dir, "#{basename}.m4b")
  fso.MoveFile(path, m4b_filename)
  return m4b_filename
end

def import_file itunes, filename
  abs_path = get_absolute_name(filename)
  puts "start to convert #{abs_path} ..."
  status = itunes.ConvertFile2(abs_path)
  WIN32OLE_EVENT.message_loop while status.InProgress
  puts "finish converting #{abs_path} ..."

  track = nil
  status.Tracks.each do |t|
    track = t
    break
  end
  return track
end

if $0 == __FILE__
  main
end
