require 'win32ole'

class TimerEvent
  def initialize
    locator = WIN32OLE.new("WbemScripting.SWbemLocator")
    @services = locator.ConnectServer(".","root/cimv2")
  end

  def put_intervaltimer timer_id, interval
    timer_class = @services.Get("__IntervalTimerInstruction")
    timer = timer_class.SpawnInstance_
    timer.IntervalBetweenEvents = interval
    timer.TimerId = timer_id
    timer.Put_
    at_exit do
      timer.Delete_
    end
  end

  def put_absolutetimer timer_id, abs_time
    timer_class = @services.Get("__AbsoluteTimerInstruction")
    timer = timer_class.SpawnInstance_
    objWbemDateTime = getWbemDateTime abs_time
    timer.EventDateTime = objWbemDateTime
    timer.TimerId = timer_id
    timer.Put_
    at_exit do
      timer.Delete_
    end
  end

  def getWbemDateTime time
    objWbemDateTime = WIN32OLE.new("WbemScripting.SWbemDateTime")
    objWbemDateTime.SetVarDate(time)
    return objWbemDateTime
  end

  def async_query wql
    sink = WIN32OLE.new("WbemScripting.SWbemSink")

    events = WIN32OLE_EVENT.new(sink,"ISWbemSinkEvents")
    events.on_event("OnObjectReady") do |objWbemObject, objWbemAsyncContext|
      yield objWbemObject, objWbemAsyncContext
    end
    @services.ExecNotificationQueryAsync sink, wql
  end

  def sync_query wql
    event_source = @services.ExecNotificationQuery wql
    loop do
      objWbemObject = event_source.NextEvent
      yield objWbemObject
    end
  end
end

def interval_async
  timer = TimerEvent.new
  timer_id = "every_two_seconds"
  timer.put_intervaltimer timer_id, 2000
  wql = %(SELECT * FROM __TimerEvent WITHIN 1 WHERE TimerId = "#{timer_id}")
  i = 0
  timer.async_query wql do |objWbemObject,objWbemAsyncContext|
    puts Time.now
    i += 1
  end
  loop do
    WIN32OLE_EVENT.message_loop
    break if i == 10
  end
end

def interval_sync
  timer = TimerEvent.new
  timer_id = "every_two_seconds"
  timer.put_intervaltimer timer_id, 2000
  wql = %(SELECT * FROM __TimerEvent WITHIN 1 WHERE TimerId = "#{timer_id}")
  i = 0
  timer.sync_query wql do |objWbemObject,objWbemAsyncContext|
    puts Time.now
    i += 1
    break if i == 10
  end
end

def absolute_async
  timer = TimerEvent.new
  timer_id = "three_seconds_after"
  timer.put_absolutetimer timer_id, Time.now + 3

  wql = %(SELECT * FROM __TimerEvent WITHIN 1 WHERE TimerId = "#{timer_id}")
  stop_flag = false
  timer.async_query wql do |objWbemObject,objWbemAsyncContext|
    puts Time.now
    stop_flag = true
  end

  WIN32OLE_EVENT.message_loop until stop_flag
end

if $0 == __FILE__
  interval_async
end

