 require 'win32ole'

 def each_instances klass
  locator = WIN32OLE.new("WbemScripting.SWbemLocator")
  services = locator.ConnectServer(".","root/cimv2")

  instances = services.InstancesOf(klass)
  instances.each do |instance|
    begin
      yield instance
    rescue WIN32OLERuntimeError => e
      STDERR.puts "error #{klass} #{instance.Name}"
    end
  end
 end

 def main
  each_instances "Win32_OperatingSystem" do |instance|
    puts "#{instance.Manufacturer} #{instance.SerialNumber}"
  end
  each_instances "Win32_BIOS" do |instance|
    puts "#{instance.Manufacturer} #{instance.SerialNumber}"
  end
  each_instances "Win32_BaseBoard" do |instance|
    puts "#{instance.Manufacturer} #{instance.SerialNumber}"
  end
  each_instances "Win32_DiskDrive" do |instance|
    puts "#{instance.Model} #{instance.Signature}"
  end
  each_instances "Win32_NetworkAdapter" do |instance|
    puts "#{instance.Manufacturer} #{instance.MACAddress}" if instance.MACAddress
  end
 end

 if $0 == __FILE__
  main
 end
