require 'win32ole'
require 'dl/import'

module Clipboard
  extend DL::Importable
  dlload "user32", "kernel32"
  
  typealias 'HGLOBAL', 'HANDLE'
  typealias 'LPVOID', 'void *'

  extern 'BOOL OpenClipboard( HWND )'
  extern 'BOOL CloseClipboard()'
  extern 'HANDLE GetClipboardData(  UINT )'
  extern 'LPVOID GlobalLock( HGLOBAL )'
  extern 'LPVOID GlobalUnlock( HGLOBAL )'

  CF_TEXT = 1

  def self.getText
    result = ""
    
    while openClipboard(0) == 0
      sleep 1
    end
    begin
      if (h = getClipboardData(CF_TEXT)) != 0
        if p = globalLock(h)
          result = p;
          globalUnlock(h);
        end
      end
    ensure
      closeClipboard
    end
    return result;
  end
end

shell = WIN32OLE.new("WScript.Shell")
shell.Run "calc.exe"
sleep 3
shell.AppActivate "d"
shell.SendKeys "1+2*3={enter}"
sleep 0.1
shell.SendKeys "^c"
sleep 0.1
value = Clipboard.getText
puts value
