require 'win32ole'

class ControlListView
  def initialize itx, title, control_id
    @itx = itx
    @title = title
    @control_id = control_id
  end

  def method_missing name, *args
    commands = %w(DoSelect FindItem GetItemCount GetSelected
       GetSelectedCount GetSubItemCount GetText
       IsSelected Select SelectAll SelectClear
       SelectInvert ViewChange)
    if commands.include?(name.to_s)
      while args.length < 2
        args << ""
      end
      @itx.ControlListView @title, "", @control_id, name.to_s, *args
    else
      super
    end
  end
end

itx = WIN32OLE.new("AutoITX3.Control")
itx.Run "eventvwr.exe"
title = "Cxg r[A"
itx.WinWaitActive title
itx.Send "{DOWN}{DOWN}{DOWN}"
sleep 0.5
clv = ControlListView.new itx, title, "SysListView321"

rows    = clv.GetItemCount.to_i
columns = clv.GetSubItemCount.to_i
0.upto(rows - 1) do |i|
  row = (0...columns).map do |j|
    clv.GetText i, j
  end
  puts row.join(" ")
end

itx.WinWaitClose title
itx.WinClose title
