require 'rubygems'
require 'hpricot'
require 'pp'

html = <<HTML
<html>
 <head><title>hpricot sample</title></head>
 <body>
  <h1 id="demo_title">Hpricot demo html</h1>
  <table id="demo_table">
   <tr>
    <th>Language</th><th>author</th>
   </tr>
   <tr>
    <td>Ruby</td><td>Matz</td>
   </tr>
   <tr>
    <td>Perl</td><td>Larry Wall</td>
   </tr>
   <tr>
    <td>Python</td><td>Guido Van Rossum</td>
   </tr>
  </table>
 </body>
</html>
HTML

doc = Hpricot(html)

recordset = []
fields = []
(doc/"table#demo_table"/"tr").each do |row|
  record = {}
  unless (row/"th").empty?
    fields = (row/"th").map{|elem| elem.inner_text}
  else
    fields.zip(row/"td") do |field, elem|
      record[field] = elem.inner_text
    end
    recordset << record
  end
end

pp recordset
