<?php
/**
 * PHP5ǻϤWebץꥱۥ ץ륹ץ
 * ͥåȥå [shop2.inc]
 * copyright(C) 2004 qnote, Inc. All right reserved.
 */

/**
 * åݲ饹
 */
abstract class Shop {

    // {{{ properties

    protected $category_list;

    // }}}
    // {{{ constructer

    public function __construct() {}

    // }}}
    // {{{ methods
    
    abstract private function _setCategoryList($db);
    abstract public function getCategory($db, $cid);
    
    // }}}

}

/**
 * åץ饹
 */
class WebShop extends Shop {

    // {{{ properties

    public $category_list;

    // }}}
    // {{{ constructer

    public function __construct($db)
    {
        $this->_setCategoryList($db);
    }

    // }}}
    // {{{ _setCategoryList
    
    /**
     * ƥ᥽å
     * @param resource $db DB³꥽
     * @access private
     */
    private function _setCategoryList($db)
    {
        $sql = sprintf("select * from category ".
                        "where flg_use = 't' and flg_del = 'f' ".
                        "order by cname");
        $res = $db->query($sql);
        if ($db->isError($res)) {
            throw new Exception("ǡ١ǥ顼ȯޤ");
        }
        
        while ($row = $res->fetchRow(DB_FETCHMODE_OBJECT)) {
            $this->category_list[] = new ShopCategory($db, $row);
        }
    }
    
    // }}}
    // {{{ getCategory
    
    /**
     * ƥ᥽å
     * @access public
     * @param resource $db DB³꥽
     * @param integer $cid ƥID
     * @return object ƥꥪ֥
     */
    public function getCategory($db, $cid)
    {
        $result = false;
        $sql = sprintf("select * from category where cid = %d ".
                        "and flg_use = 't' and flg_del = 'f'",
                        $cid);
        $res = $db->query($sql);
        if ($db->isError($res)) {
            throw new Exception("ǡ١ǥ顼ȯޤ");
        }
        
        while ($row = $res->fetchRow(DB_FETCHMODE_OBJECT)) {
            $result = new ShopCategory($db, $row);
        }
        return $result;
    }
    
    // }}}

}

/**
 * å״饹
 */
class AdmShop extends Shop {

    // {{{ properties

    /**
     * ƥ
     * @access public
     * @var array
     */
    public $category_list;

    // }}}
    // {{{ constructer

    public function __construct($db)
    {
        $this->_setCategoryList($db);
    }

    // }}}
    // {{{ _setCategoryList
    
    /**
     * ƥ᥽å
     * @access private
     * @param resource $db DB³꥽
     */
    private function _setCategoryList($db)
    {
        $sql = sprintf("select * from category ".
                        "where flg_del = 'f' ".
                        "order by cname");
        $res = $db->query($sql);
        if ($db->isError($res)) {
            throw new Exception("ǡ١ǥ顼ȯޤ");
        }
        
        while ($row = $res->fetchRow(DB_FETCHMODE_OBJECT)) {
            $this->category_list[] = new AdmCategory($db, $row);
        }
    }
    
    // }}}
    // {{{ getCategory
    
    /**
     * ƥ᥽å
     * @access public
     * @param resource $db DB³꥽
     * @param integer $cid ƥID
     * @return object ƥꥪ֥
     */
    public function getCategory($db, $cid)
    {
        $result = false;
        $sql = sprintf("select * from category where cid = %d ",
                        $cid);
        $res = $db->query($sql);
        if ($db->isError($res)) {
            throw new Exception("ǡ١ǥ顼ȯޤ");
        }
        
        while ($row = $res->fetchRow(DB_FETCHMODE_OBJECT)) {
            $result = new AdmCategory($db, $row);
        }
        return $result;
    }
    
    // }}}
    // {{{ registCategory
    
    /**
     * ƥϿ᥽å
     * @access public
     * @param resource $db DB³꥽
     * @param array $data ƥǡ
     */
    public function registCategory($db, $data)
    {
        $db->autoCommit(false);
        $sql = "lock table category in share row exclusive mode";
        $res = $db->query($sql);
        if ($db->isError($res)) {
            $db->rollback();
            throw new Exception("ǡ١ǥ顼ȯޤ");
        }
        $sql = "select max(cid) from category ";
        $max = $db->getOne($sql);
        if ($db->isError($max)) {
            $db->rollback();
            throw new Exception("ǡ١ǥ顼ȯޤ");
        }
        
        $cid = $max + 1;
        
        $sql = sprintf("insert into category ".
                        "(cid, cname, flg_use, reg_time, mod_time) ".
                        "values (%d, %s, %s, ".
                        "CURRENT_TIMESTAMP, CURRENT_TIMESTAMP)",
                        $cid,
                        $db->quoteSmart($data["cname"]),
                        $db->quoteSmart($data["flg_use"]));
        $res = $db->query($sql);
        if ($db->isError($res)) {
            $db->rollback();
            throw new Exception("ǡ١ǥ顼ȯޤ");
        }
        $db->commit();
    }
    
    // }}}
    // {{{ updateCategory

    /**
     * ƥ깹᥽å
     * @access public
     * @param resource $db DB³꥽
     * @param array $data ƥǡ
     */
    public function updateCategory($db, $data)
    {
        $db->autoCommit(false);
        
        switch ($data["flg_del"]) {
            case true:
                $sql = sprintf("update category set flg_del = 't', ".
                                "del_time = CURRENT_TIMESTAMP ".
                                "where cid = %d",
                                $data["cid"]);
                break;
            case false:
                $sql = sprintf("update category set ".
                                "cname = %s, flg_use = %s, ".
                                "mod_time = CURRENT_TIMESTAMP ".
                                "where cid = %d",
                                $db->quoteSmart($data["cname"]),
                                $db->quoteSmart($data["flg_use"]),
                                $data["cid"]);
                break;
        }
        $res = $db->query($sql);
        if ($db->isError($res)) {
            $db->rollback();
            throw new Exception("ǡ١ǥ顼ȯޤ");
        }
        $db->commit();
    }

    // }}}
    // {{{ registItem
    
    /**
     * Ͽ᥽å
     * @access public
     * @param resource $db DB³꥽
     * @param array $data ʥǡ
     */
    public function registItem($db, $data)
    {
        $db->autocommit(false);

        $sql = "lock table item in share row exclusive mode";
        $res = $db->query($sql);
        if ($db->isError($res)) {
            $db->rollback();
            throw new Exception("ǡ١ǥ顼ȯޤ");
        }
        
        $sql = "select max(item_id) from item";
        $max = $db->getOne($sql);
        if ($db->isError($res)) {
            $db->rollback();
            throw new Exception("ǡ١ǥ顼ȯޤ");
        }
        
        $item_id = $max + 1;

        if ($data["image"]) {
            if (!$image = $this->saveImage($item_id,
                                                SHOP_IMAGE_DIR,
                                                $data["image"])) {
                $db->rollback();
                throw new Exception("顼");
            }
        }

        $sql = sprintf("insert into item (item_id, item_name, price, unit, ".
                        "description, image, cid, flg_use, reg_time, mod_time".
                        ") values (%d, %s, %d, %s, %s, %s, %d, %s, ".
                        "CURRENT_TIMESTAMP, CURRENT_TIMESTAMP)",
                        $item_id,
                        $db->quoteSmart($data["item_name"]),
                        $db->quoteSmart($data["price"]),
                        $db->quoteSmart($data["unit"]),
                        $db->quoteSmart($data["description"]),
                        $db->quoteSmart($image),
                        $data["cid"],
                        $db->quoteSmart($data["flg_use"]));
        $res = $db->query($sql);
        if ($db->isError($res)) {
            $db->rollback();
            throw new Exception("ǡ١ǥ顼ȯޤ");
        }

        $db->commit();
    }
    
    // }}}
    // {{{ updateItem

    /**
     * ʹ᥽å
     * @access public
     * @param resource $db DB³꥽
     * @param array $data ʥǡ
     */
    public function updateItem($db, $data)
    {
        $db->autocommit(false);

        switch ($data["flg_del"]) {
            case true:
                $sql = sprintf("update item set flg_del = 't', ".
                                "del_time = CURRENT_TIMESTAMP ".
                                "where item_id = %d",
                                $data["item_id"]);
                break;
            case false:
                if ($data["image"]) {
                    if (!$image = $this->saveImage($data["item_id"],
                                                    SHOP_IMAGE_DIR,
                                                    $data["image"])) {
                        $db->rollback();
                        throw new Exception("顼");
                    }
                }
                $sql = sprintf("update item set ".
                                "item_name = %s, price = %d, unit = %s, ".
                                "description = %s, image = %s, cid = %d, ".
                                "flg_use = %s, mod_time = CURRENT_TIMESTAMP ".
                                "where item_id = %d",
                                $db->quoteSmart($data["item_name"]),
                                $db->quoteSmart($data["price"]),
                                $db->quoteSmart($data["unit"]),
                                $db->quoteSmart($data["description"]),
                                $db->quoteSmart($image),
                                $data["cid"],
                                $db->quoteSmart($data["flg_use"]),
                                $data["item_id"]);
                break;
        }
        $res = $db->query($sql);
        if ($db->isError($res)) {
            $db->rollback();
            throw new Exception("ǡ١ǥ顼ȯޤ");
        }
        $db->commit();
    }

    // }}}
    // {{{ deleteImage

    /**
     * ʲ᥽å
     * @access public
     * @param resource $db DB³꥽
     * @param array $data ǡ
     */
    public function deleteImage($db, $data)
    {
        $db->autocommit(false);

        if (!$this->deleteFile(SHOP_IMAGE_DIR, $data["image"])) {
            $db->rollback();
            throw new Exception("顼");
        }

        $sql = sprintf("update item set image = '', ".
                        "mod_time = CURRENT_TIMESTAMP ".
                        "where item_id = %d",
                        $data["item_id"]);
        $res = $db->query($sql);
        if ($db->isError($res)) {
            $db->rollback();
            throw new Exception("ǡ١ǥ顼ȯޤ");
        }
        $db->commit();
    }

    // }}}
    // {{{ deleteFile

    /**
     * ե᥽å
     * @access public
     * @param string $path ѥʸ
     * @param string $filename ե̾
     * @return bool
     */
    public function deleteFile($path, $filename)
    {
        $filepath = $path.$filename;
        if (!file_exists($filepath)) {
            return false;
        }
        if (!unlink($filepath)) {
            return false;
        }
        return true;
    }

    // }}}
    // {{{ saveImage
    
    /**
     * ե¸᥽å
     * @param int $id ID
     * @param string $path ե¸ǥ쥯ȥ
     * @param array $tmp_file 
     * @return string $filename ե̾
     */
    public function saveImage($id, $path, $tmp_file)
    {
        list($name, $ext) = explode(".", basename($tmp_file));
        $rename_path = sprintf("%sitem_%d.%s",
                                $path,
                                $id,
                                $ext);
        if (!rename($tmp_file, $rename_path)) {
            return false;
        }
        return basename($rename_path);
    }
    
    // }}}
    // {{{ unlinkTmp
    
    /**
     * եõ᥽å
     * @param string $path ե¸ǥ쥯ȥ
     * @return bool true
     */
    public function unlinkTmp($path)
    {
        $image_files = scandir($path);
        foreach ($image_files as $file) {
            if (is_file("$path".$file) && ereg("^tmp_", $file)) {
                if (!@unlink("$path".$file)) {
                    throw new Exception("顼");
                }
            }
        }
        return true;
    }
    
    // }}}
    // {{{ makeTmp
    
    /**
     * ե᥽å
     * @param string $path ե¸ǥ쥯ȥ
     * @param array &$sess $_SESSION
     * @return bool true
     */
    public function makeTmp($path, &$sess)
    {
        $this->unlinkTmp($path);
        $sess["image"] = array();
        list($key, $file) = each($_FILES);
        switch ($file["type"]) {
            case "image/jpeg":
            case "image/pjpeg":
                $ext = "jpg";
                break;
            case "image/png":
                $ext = "png";
                break;
            case "image/gif":
                $ext = "gif";
                break;
            default :
                continue;
        }

        $file_path = sprintf("%stmp_%s.%s",
                            $path,
                            basename($file["tmp_name"]),
                            $ext);
        if (!$file["error"]) {
            if (move_uploaded_file($file["tmp_name"], $file_path)) {
                $sess["image"] = $file_path;
            }
        }
    }
    
    // }}}

}

/**
 * ƥݲ饹
 */
abstract class Category {

    // {{{ properties

    protected $cid;
    protected $cname;
    protected $flg_use;
    protected $flg_del;
    protected $reg_time;
    protected $mod_time;
    protected $del_time;
    protected $item_list;

    // }}}
    // {{{ constructer

    public function __construct() {}

    // }}}
    // {{{ methods

    abstract private function _setCategory($obj);
    abstract private function _setItemList($db);

    // }}}

}
/**
 * ƥꥯ饹
 */
class ShopCategory extends Category {

    // {{{ properties

    /**
     * ƥID
     * @access public
     * @var integer
     */
    public $cid;

    /**
     * ƥ̾
     * @access public
     * @var string
     */
    public $cname;

    /**
     * 
     * @access public
     * @var array
     */
    public $item_list;

    // }}}
    // {{{ constructer

    public function __construct($db, $obj)
    {
        $this->_setCategory($obj);
        $this->_setItemList($db);
    }

    // }}}
    // {{{ _setCategory

    /**
     * ƥꥻåȥ᥽å
     * @access private
     * @param object $obj ƥꥪ֥
     */
    private function _setCategory($obj)
    {
        $this->cid            = $obj->cid;
        $this->cname          = $obj->cname;
    }

    // }}}
    // {{{ _setItemList

    /**
     * 󥻥åȥ᥽å
     * @access private
     * @param resource $db DB³꥽
     */
    private function _setItemList($db)
    {
        $sql = sprintf("select * from item where cid = %d ".
                        "and flg_use = 't' and flg_del = 'f' ".
                        "order by item_name, mod_time desc",
                        $this->cid);
        $res = $db->query($sql);
        if ($db->isError($res)) {
            throw new Exception("ǡ١ǥ顼ȯޤ");
        }
        
        while ($row = $res->fetchRow(DB_FETCHMODE_OBJECT)) {
            $this->item_list[] = new ShopItem($row);
        }
    }

    // }}}
    // {{{ getItem
    
    /**
     * ʼ᥽å
     * @access public
     * @param resource $db DB³꥽
     * @param integer $item_id ID
     */
    public function getItem($db, $item_id)
    {
        $result = false;
        $sql = sprintf("select * from item where item_id = %d ".
                        "and flg_del = 'f' and flg_use = 't' ",
                        $item_id);
        $res = $db->query($sql);
        if ($db->isError($res)) {
            throw new Exception("ǡ١ǥ顼ȯޤ");
        }
        
        while ($row = $res->fetchRow(DB_FETCHMODE_OBJECT)) {
            $result = new ShopItem($row);
        }
        return $result;
    }
    
    // }}}

}
/**
 * ƥ饹
 */
class AdmCategory extends Category {

    // {{{ properties

    /**
     * ID
     * @access public
     * @var integer
     */
    public $cid;

    /**
     * ̾
     * @access public
     * @var string
     */
    public $cname;

    /**
     * ѥե饰(t/f)
     * @access public
     * @var string
     */
    public $flg_use;

    /**
     * Ͽ
     * @access public
     * @var string
     */
    public $reg_time;

    /**
     * 
     * @access public
     * @var string
     */
    public $mod_time;

    /**
     * 
     * @access public
     * @var array
     */
    public $item_list;

    // }}}
    // {{{ constructer

    public function __construct($db, $obj)
    {
        $this->_setCategory($obj);
        $this->_setItemList($db);
    }

    // }}}
    // {{{ _setCategory

    /**
     * ƥꥻåȥ᥽å
     * @access private
     * @param object $obj ƥꥪ֥
     */
    private function _setCategory($obj)
    {
        $this->cid            = $obj->cid;
        $this->cname          = $obj->cname;
        $this->flg_use        = $obj->flg_use;
        $this->reg_time       = $obj->reg_time;
        $this->mod_time       = $obj->mod_time;
    }

    // }}}
    // {{{ _setItemList

    /**
     * 󥻥åȥ᥽å
     * @access private
     * @param resource $db DB³꥽
     */
    private function _setItemList($db)
    {
        $sql = sprintf("select * from item where cid = %d ".
                        "and flg_del = 'f' ".
                        "order by mod_time desc, item_name",
                        $this->cid);
        $res = $db->query($sql);
        if ($db->isError($res)) {
            throw new Exception("ǡ١ǥ顼ȯޤ");
        }
        
        while ($row = $res->fetchRow(DB_FETCHMODE_OBJECT)) {
            $this->item_list[] = new AdmItem($row);
        }
    }

    // }}}
    // {{{ getItem
    
    /**
     * ʼ᥽å
     * @access public
     * @param resource $db DB³꥽
     * @param integer $item_id ID
     * @return object ʥ֥
     */
    public function getItem($db, $item_id)
    {
        $result = false;
        $sql = sprintf("select * from item where item_id = %d ",
                        $item_id);
        $res = $db->query($sql);
        if ($db->isError($res)) {
            throw new Exception("ǡ١ǥ顼ȯޤ");
        }
        
        while ($row = $res->fetchRow(DB_FETCHMODE_OBJECT)) {
            $result = new AdmItem($row);
        }
        return $result;
    }
    
    // }}}

}

/**
 * ݲ饹
 */
abstract class Item {

    // {{{ properties

    protected $item_id;
    protected $item_name;
    protected $price;
    protected $unit;
    protected $description;
    protected $image;
    protected $cid;
    protected $flg_use;
    protected $flg_del;
    protected $reg_time;
    protected $mod_time;
    protected $del_time;

    // }}}
    // {{{ constructer

    public function __construct() {}

    // }}}
    // {{{ 

    abstract private function _setItem($obj);

    // }}}

}
/**
 * ʥ饹
 */
class ShopItem extends Item {

    // {{{ properties

    /**
     * ID
     * @access public
     * @var integer
     */
    public $item_id;

    /**
     * ̾
     * @access public
     * @var string
     */
    public $item_name;

    /**
     * 
     * @access public
     * @var integer
     */
    public $price;

    /**
     * ñ
     * @access public
     * @var string
     */
    public $unit;

    /**
     * 
     * @access public
     * @var string
     */
    public $description;

    /**
     * ʲե̾
     * @access public
     * @var string
     */
    public $image;

    // }}}
    // {{{ constructer

    public function __construct($obj)
    {
        $this->_setItem($obj);
    }

    // }}}
    // {{{ _setItem

    /**
     * ʥåȥ᥽å
     * @access private
     * @param object ʥ֥
     */
    private function _setItem($obj)
    {
        $this->item_id     = $obj->item_id;
        $this->item_name   = $obj->item_name;
        $this->price       = $obj->price;
        $this->unit        = $obj->unit;
        $this->description = $obj->description;
        $this->image       = $obj->image;
    }

    // }}}

}
/**
 * ʴ饹
 */
class AdmItem extends Item {

    // {{{ properties

    /**
     * ID
     * @access public
     * @var integer
     */
    public $item_id;

    /**
     * ̾
     * @access public
     * @var string
     */
    public $item_name;

    /**
     * 
     * @access public
     * @var integer
     */
    public $price;

    /**
     * ñ
     * @access public
     * @var string
     */
    public $unit;

    /**
     * 
     * @access public
     * @var string
     */
    public $description;

    /**
     * ʲե̾
     * @access public
     * @var string
     */
    public $image;

    /**
     * ƥID
     * @access public
     * @var integer
     */
    public $cid;

    /**
     * ѥե饰(t/f)
     * @access public
     * @var string
     */
    public $flg_use;

    /**
     * Ͽ
     * @access public
     * @var string
     */
    public $reg_time;

    /**
     * 
     * @access public
     * @var string
     */
    public $mod_time;

    // }}}
    // {{{ constructer

    public function __construct($obj)
    {
        $this->_setItem($obj);
    }

    // }}}
    // {{{ _setItem

    /**
     * ʥåȥ᥽å
     * @access private
     * @param object ʥ֥
     */
    private function _setItem($obj)
    {
        $this->item_id     = $obj->item_id;
        $this->item_name   = $obj->item_name;
        $this->price       = $obj->price;
        $this->unit        = $obj->unit;
        $this->description = $obj->description;
        $this->image       = $obj->image;
        $this->cid         = $obj->cid;
        $this->flg_use     = $obj->flg_use;
        $this->reg_time    = $obj->reg_time;
        $this->mod_time    = $obj->mod_time;
    }

    // }}}

}

/**
 * ʸ饹
 */
class ShopOrder {

    // {{{ properties

    // }}}
    // {{{ constructer

    public function __construct()
    {
    }

    // }}}
    // {{{ registOrder

    /**
     * ʸϿ᥽å
     * @access public
     * @param resource $db DB³꥽
     * @param array $customer Ŀ;
     * @param array $cart Ⱦ
     * @param array $num ʸ
     */
    public function registOrder($db, $customer, $cart, $num)
    {
        $db->autocommit(false);

        $sql = "lock table shopper in share row exclusive mode";
        $res = $db->query($sql);
        if ($db->isError($res)) {
            $db->rollback();
            throw new Exception("ǡ١ǥ顼ȯޤ");
        }

        $sql = sprintf("select max(shopper_id) from shopper");
        $max = $db->getOne($sql);
        if ($db->isError($res)) {
            $db->rollback();
            throw new Exception("ǡ١ǥ顼ȯޤ");
        }
        $shopper_id = $max + 1;

        $sql = sprintf("insert into shopper values (%d, %s, %s, %s, ".
                        "%s, %s, %s, %s, %s, %s, ".
                        "CURRENT_TIMESTAMP)",
                        $shopper_id,
                        $db->quoteSmart($customer["name"]),
                        $db->quoteSmart($customer["name_k"]),
                        $db->quoteSmart($customer["email"]),
                        $db->quoteSmart($customer["phone"]),
                        $db->quoteSmart($customer["postal"]),
                        $db->quoteSmart($customer["address1"]),
                        $db->quoteSmart($customer["address2"]),
                        $db->quoteSmart($customer["address3"]),
                        $db->quoteSmart($customer["remarks"]));
        $res = $db->query($sql);
        if ($db->isError($res)) {
            $db->rollback();
            throw new Exception("ǡ١ǥ顼ȯޤ");
        }

        $id_arr = array_keys($cart);
        for ($i=0; $i < count($id_arr); $i++) {
            $item_id = $id_arr[$i];

            $sql = sprintf("insert into purchase values (".
                            "%d, %d, %s, %d, %d)",
                            $shopper_id,
                            ($i+1),
                            $db->quoteSmart($cart[$item_id]->item_name),
                            $cart[$item_id]->price,
                            $num[$item_id]);
            $res = $db->query($sql);
            if ($db->isError($res)) {
                 $db->rollback();
                 throw new Exception("ǡ١ǥ顼ȯޤ4");
            }

        }

        $db->commit();
    }

    // }}}

}

/**
 * ʸ饹
 */
class AdmOrder {

    // {{{ properties

    /**
     * ʸID
     * @access public
     * @var integer
     */
    public $shopper_id;

    /**
     * ̾
     * @access public
     * @var string
     */
    public $name;

    /**
     * ̾()
     * @access public
     * @var string
     */
    public $name_k;

    /**
     * ᡼륢ɥ쥹
     * @access public
     * @var string
     */
    public $email;

    /**
     * ֹ
     * @access public
     * @var string
     */
    public $phone;

    /**
     * ͹ֹ(7)
     * @access public
     * @var string
     */
    public $postal;

    /**
     * 1
     * @access public
     * @var string
     */
    public $address1;

    /**
     * 2
     * @access public
     * @var string
     */
    public $address2;

    /**
     * 3
     * @access public
     * @var string
     */
    public $address3;

    /**
     * 
     * @access public
     * @var string
     */
    public $remarks;

    /**
     * Ͽ
     * @access public
     * @var string
     */
    public $reg_time;

    /**
     * ʸ
     * @access public
     * @var array
     */
    public $order_list;

    // }}}
    // {{{ constructer

    public function __construct()
    {
        $this->shopper_id = "";
        $this->name       = "";
        $this->name_k     = "";
        $this->email      = "";
        $this->phone      = "";
        $this->postal     = "";
        $this->address1   = "";
        $this->address2   = "";
        $this->address3   = "";
        $this->remarks    = "";
        $this->reg_time   = "";
        $this->order_list = array();
    }

    // }}}
    // {{{ getShopperCount

    /**
     * ʸȥ᥽å
     * @access public
     * @param resorce $db DB³꥽
     * @param integer $stime ϥॹ
     * @param integer $etime λॹ
     * @return integer $result ʸ
     */
    public function getShopperCount($db, $stime = false, $etime = false)
    {
        $addstate = 0;
        if ($stime) {
            $addstate = 1;
            $sdate = date("Y/m/d G:i:s", $stime);
        }
        if ($etime) {
            $addstate += 2;
            $edate = date("Y/m/d G:i:s", $etime);
        }
        switch ($addstate) {
            case 1:
                $add = sprintf("where reg_time >= '%s'", $sdate);
                break;
            case 2:
                $add = sprintf("where reg_time <= '%s'", $edate);
                break;
            case 3:
                $add = sprintf("where reg_time between '%s' and '%s'",
                                $sdate, $edate);
                break;
            default:
                $add = "";
        }
        
        $sql = sprintf("select count(*) from shopper %s ", $add);
        $res = $db->getOne($sql);
        if ($db->isError($res)) {
            throw new Exception("ǡ١ǥ顼ȯޤ");
        }
        return $res;
    }

    // }}}
    // {{{ getShopperList

    /**
     * ʸ᥽å
     * @access public
     * @param resorce $db DB³꥽
     * @param integer $limit 
     * @param integer $offset ϰ
     * @param integer $stime ϥॹ
     * @param integer $etime λॹ
     * @return array $result ʸ
     */
    public function getShopperList($db, $limit, $offset, $stime = false, $etime = false)
    {
        $result = array();
        $addstate = 0;
        if ($stime) {
            $addstate = 1;
            $sdate = date("Y/m/d G:i:s", $stime);
        }
        if ($etime) {
            $addstate += 2;
            $edate = date("Y/m/d G:i:s", $etime);
        }
        switch ($addstate) {
            case 1:
                $add = sprintf("where reg_time >= '%s'", $sdate);
                break;
            case 2:
                $add = sprintf("where reg_time <= '%s'", $edate);
                break;
            case 3:
                $add = sprintf("where reg_time between '%s' and '%s'",
                                $sdate, $edate);
                break;
            default:
                $add = "";
        }
        
        $sql = sprintf("select * from shopper %s ".
                        "order by reg_time desc, shopper_id ",
                        $add);
        $res = $db->limitQuery($sql, $offset, $limit);
        if ($db->isError($res)) {
            throw new Exception("ǡ١ǥ顼ȯޤ");
        }

        while ($row = $res->fetchRow(DB_FETCHMODE_OBJECT)) {
            $this->_setShopper($row);
            $result[] = clone $this;
        }
        return $result;
    }

    // }}}
    // {{{ getShopper

    /**
     * ʸ᥽å
     * @access public
     * @param resorce $db DB³꥽
     * @param integer $shopper_id ʸID
     * @return object $this ʸ󥪥֥
     */
    public function getShopper($db, $shopper_id)
    {
        
        $sql = sprintf("select s.*,p.pno, p.item_name, p.price, p.quantity ".
                        "from shopper as s join purchase as p ".
                        "on (s.shopper_id = p.shopper_id) ".
                        "where s.shopper_id = %d ".
                        "order by p.pno",
                        $shopper_id);
        $res = $db->query($sql);
        if ($db->isError($res)) {
            throw new Exception("ǡ١ǥ顼ȯޤ");
        }

        $rows = $res->numRows();
        $row = $res->fetchRow(DB_FETCHMODE_OBJECT);
        $i = 0;
        while ($i < $rows) {
            $shopper_id = $row->shopper_id;
            $this->_setShopper($row);
            while ($i < $rows && $shopper_id == $row->shopper_id) {
                $this->_setPurchase($row);
                $row = $res->fetchRow(DB_FETCHMODE_OBJECT);
                $i++;
            }
        }
        return $this;
    }

    // }}}
    // {{{ _setShopper

    /**
     * ʸ󥻥åȥ᥽å
     * @access private
     * @param object $obj ʸ󥪥֥
     */
    private function _setShopper($obj)
    {
        $this->shopper_id = $obj->shopper_id;
        $this->name       = $obj->name;
        $this->name_k     = $obj->name_k;
        $this->email      = $obj->email;
        $this->phone      = $obj->phone;
        $this->postal     = $obj->postal;
        $this->address1   = $obj->address1;
        $this->address2   = $obj->address2;
        $this->address3   = $obj->address3;
        $this->remarks    = $obj->remarks;
        $this->reg_time   = $obj->reg_time;
    }

    // }}}
    // {{{ _setPurchase

    /**
     * ʸܺپ󥻥åȥ᥽å
     * @access private
     * @param object $obj ʸܺپ󥪥֥
     */
    private function _setPurchase($obj)
    {
        unset($obj->shopper_id);
        unset($obj->name);
        unset($obj->name_k);
        unset($obj->email);
        unset($obj->phone);
        unset($obj->postal);
        unset($obj->address1);
        unset($obj->address2);
        unset($obj->address3);
        unset($obj->remarks);
        unset($obj->reg_time);
        $this->order_list[] = $obj;
    }

    // }}}

}
?>