<?php
/**
 * PHP5で始めるWebアプリケーション構築ガイド サンプルスクリプト
 * RSSリーダー SimpleXML版[rss_simplexml.php]
 * copyright(C) 2004 qnote, inc. All right reserved.
 */
$db_path = "/usr/local/apache2/rss";
try {
	$db = new SQLiteDatabase($db_path);
	$sql = "select * from sites order by site_id";
	$res = $db->query($sql);
} catch (Exception $e) {
	die(sprintf("Error: %s<br>", $e->getMessage()));
}
?>
<html>
<head>
<meta http-equiv="content-type" content="text/html;charset=utf-8">
<link rel="stylesheet" type="text/css" href="css/rssreader.css">
<title>Headline</title>
</head>
<body>
<?php
while ($res->valid()) {
	$row = $res->current();

	/* RSSを読んで解析する */
	$rss = simplexml_load_file($row["url"]);
	printf('<div class="title"><a href="%s" target="blank">%s</a></div>', 
				$rss->channel->link,
				$rss->channel->title);
	printf('<p>%s</p>', $rss->channel->description);
	print('<table border=1 class="table1" cellpadding=6 cellspacing=1>');
	foreach ($rss->item as $item) {
		print('<tr><td class="td1">');
		printf('<a href="%s" target="_blank">%s</a>', 
					$item->link,
					$item->title);
		print('</td></tr>');
	}
	print('</table><br>');
	$res->next();
}
unset($db);
?>
</body>
</html>
