<?php
/**
 * PHP5で始めるWebアプリケーション構築ガイド サンプルスクリプト
 * RSSリーダー last RSS版　[rss_lastrss.php]
 * copyright(C) 2004 qnote, inc. All right reserved.
 */
require_once('./lastRSS.php');
$db_path = "/usr/local/apache2/rss"
try {
	$db = new SQLiteDatabase($db_path);
	$sql = "select * from sites order by site_id";
	$res = $db->query($sql);
} catch (Exception $e) {
	die(sprintf("Error: %s<br>", $e->getMessage()));
}
?>
<html>
<head>
<meta http-equiv="content-type" content="text/html;charset=utf-8">
<link rel="stylesheet" type="text/css" href="css/rssreader.css">
<title>Headline</title>
</head>
<body>
<?php
while ($res->valid()) {
	$row = $res->current();

	/* RSSの設定 */
	$rss = new lastRSS;
	$rss->cache_dir = './cache'; 
	$rss->cache_time = $row["cache_time"];
	$rss->cp = "UTF-8";

	$rss_array = $rss->get($row["url"]);

	printf('<div class="title"><a href="%s" target="blank">%s</a></div>', 
				$rss_array["link"],
				$rss_array["title"]);
	printf('<p>%s</p>', $rss_array["description"]);
	print('<table border=1 class="table1" cellpadding=6 cellspacing=1>');
	foreach ($rss_array["items"] as $item) {
		print('<tr><td class="td1">');
		printf('<a href="%s" target="_blank">%s</a>', 
					$item["link"],
					$item["title"]);
		print('</td></tr>');
	}
	print('</table><br>');
	$res->next();
}
unset($db);
?>
</body>
</html>
