<?php
/*
 * PHP5ǻϤWebץꥱۥ ץ륹ץ
 * Smartyץ饰[function.minicalendar.php]
 * copyright(C) qnote, Inc.All right reserved.
 * 
 * Smarty plugin
 * -------------------------------------------------------------
 * Type:        function
 * Name:        minicalendar
 * Version:     1.0
 * Date:        July 26, 2004
 * Author:      Takuji Shigeta <qnote,Inc.>
 * Purpose:     ߥ˥
 * Install:     drop into the plugin directory
 * Required input:
 *              none
 *
 * Optional input: 
 *              date = ɽ YYYY-MM-DDǻꡣDDϾά
 *              links = դ󥯤ˤ
 *              link_url = URL
 *              link_param = ϤGETѥ᡼
 * 
 * Examples:    {minicalendar date="2004-07-01" links=$date_array link_url="index.php" link_param="mode=show"}
 * -------------------------------------------------------------
 */
function smarty_function_minicalendar($params = array()) {

    // ɽ
    if ($params["date"] != "") {
        $year = date("Y", strtotime($params["date"]));
        $month = date("m", strtotime($params["date"]));
    } else {
        $year = date("Y");
        $month = date("m");
    }
    
    // 󥯤
    if (is_array($params["links"])) {
        foreach ($params["links"] as $link) {
            $links[] = date("Y-m-d", strtotime($link));
        }
    } else {
        $links = (array) $params["links"];
    }
    
    // URL
    if ($params["link_url"]) {
        $link_url = $params["link_url"];
    } else {
        $link_url = $_SERVER["PHP_SELF"];
    }
    
    // Ϥѥ᡼
    if ($params["link_param"]) {
        $link_param = "&".$params["link_param"];
    }
    
    //ʸ
    $wd_str = array("", "", "", "", "", "", "");
    
    $today = getdate();
    
    //ɽ1
    $first_day = getdate(mktime(0, 0, 0, $month, 1, $year));
    $first_wday = $first_day["wday"];
    
    //إåHTML
    $_html = sprintf("<table class='calender' cellspacing=1 cellpadding=1>\n".
               "<tr><td colspan=7 class='cal_tab'><b>%dǯ%d</b></td></tr>\n", 
                        $year,
                        $month);

    //ɽ
    $last_day = date("d", mktime(0, 0, 0, $month+1, 0, $year));
    
    //Ԥ
    $_html .= "<tr>\n";
    for ($i = 0; $i <= 6; $i++) {
        if ($i == 0) {
            $td_class = "cal_cap_sun";
        } elseif ($i == 6) {
            $td_class = "cal_cap_sat";
        } else {
            $td_class = "cal_cap_wd";
        }
        $_html .= sprintf("<td class='%s'>%s</td>\n", $td_class, $wd_str[$i]);
    }
    $_html .= "</tr>\n";

    //Ԥ
    $_html .= "<tr>\n";
    for ($i = 0; $i < $first_wday; $i++) {
        $_html .= "<td class='cal_wd'>&nbsp;</td>\n";
    }
    $w = $first_wday;
    //
    for ($i = 1; $i <= $last_day; $i++) {
        if ($i == date("d") && $year == date("Y") && $month == date("m")) {
            $td_class = "cal_today";
        } elseif ($w == 0) {
            $td_class = "cal_sun";
        } elseif ($w == 6) {
            $td_class = "cal_sat";
        } else {
            $td_class = "cal_wd";
        }
        if ($w == 0) $body .= "<tr>\n";
        $daykey = date("Y-m-d", strtotime($year."-".$month."-".$i));
        $_html .= "<td class='$td_class'>";
        //󥯻ʤAɲ
        if (in_array($daykey, $links)) {
            $_html .= sprintf("<span style='font-size:5px'></span>".
                              "<a href='%s?target_date=%s%s'>%d</a>",
                                $link_url,
                                $daykey,
                                $link_param,
                                $i);
        } else {
            $_html .= $i;
        }
        $_html .= "</td>\n";
        //Ԥʤ
        if ($w == 6) {
            $_html .= "</tr>\n";
            $w = 0;
        } else {
            $w++;
        }
    }
    //ǽԤǤʤж
    if ($w != 0) {
        for ($i = $w; $i <= 6; $i++) {
            $_html .= "<td class='cal_wd'>&nbsp;</td>\n";
        }
    }
    $_html .= "<tr><td colspan=7 class='cal_tab'>&nbsp;</td></tr>\n".
              "\n</table>";

    return $_html;

}

// }}}
?>