<?php
/**
 * PHP5ǻϤWebץꥱۥ ץ륹ץ
 *  [diary.inc]
 * copyright(C) qnote, Inc.All right reserved.
 */


// {{{

/**
 * 饹
 */
class Diary {
    
    // {{{ properties
    
    /**
     * @access protected
     * @var $_db object MySQLiǡ١֥ѿ
     */
    protected $_db;
    
    // }}}
    // {{{
    
    /**
     * MySQLiǡ١ϥ᥽å
     * @access protected
     */
    protected function connect_db()
    {
        $this->_db = new mysqli;
        $this->_db->connect(DIARY_DBHOST,DIARY_DBUSER,DIARY_DBPWD,DIARY_DBNAME);
        if (!$this->_db->host_info) {
            throw new Exception("ǡ١³顼");
        }
    }

    // }}}
    // {{{

    /**
     * ε
     * @param string $target_date (YYYYMMDD)
     * @return mixed $ret ֥
     */
    public function listGet($target_date) {
        $this->connect_db();
        $strtime = strtotime($target_date);
        $sql = sprintf("SELECT * FROM DIARY WHERE YEAR(reg_time) = %d AND ".
                        "MONTH(reg_time) = %d AND DAY(reg_time) = %d ".
                        "ORDER BY reg_time DESC",
                        date("Y", $strtime),
                        date("m", $strtime),
                        date("d", $strtime));
        $res = $this->_db->query($sql);
        if ($this->_db->error) {
            throw new Exception("顼");
        }
        $ret = array();
        while($row = $res->fetch_object()) {
            $ret[] = $row;
        }
        return $ret;
    }

    // }}}
    // {{{

    /**
     * IDε
     * @param int $id ID
     * @return mixed $ret ֥
     */
    public function offsetGet($id) {
        $this->connect_db();
        $sql = sprintf("SELECT * FROM DIARY WHERE id = %d ",
                        $this->_db->real_escape_string($id));
        $res = $this->_db->query($sql);
        if ($this->_db->error) {
            throw new Exception("顼");
        }
        $ret = $res->fetch_object();
        if ($ret) {
            return array($ret);
        } else {
            return NULL;
        }
    }

    // }}}
    // {{{

    /**
     * ǿε
     * @return mixed $ret ֥
     */
    public function latestGet() {
        //MySQL³
        $this->connect_db();
        $sql = "SELECT * FROM DIARY ORDER BY reg_time DESC LIMIT 1";
        $res = $this->_db->query($sql);
        if ($this->_db->error) {
            throw new Exception("顼");
        }
        $ret = $res->fetch_object();
        if ($ret) {
            return array($ret);
        } else {
            return NULL;
        }
    }

    // }}}
    // {{{

    /**
     * Ƕ
     * @param int $limit 
     * @return mixed $ret ֥
     */
    public function pastGet($limit) {
        //MySQL³
        $this->connect_db();

        $sql = sprintf("SELECT * FROM DIARY ORDER BY id DESC LIMIT %d;",
                        $limit);
        $res = $this->_db->query($sql);
        if ($this->_db->error) {
            throw new Exception("顼");
        }
        $ret = array();
        while($row = $res->fetch_object()) {
            $ret[] = $row;
        }
        return $ret;
    }

    // }}}
    // {{{

    /**
     * ε
     * @param string $target_date (YYYYMMDD)
     * @return mixed $ret ֥
     */
    public function dateList($target_date) {
        //MySQL³
        $this->connect_db();

        $sql = sprintf("SELECT reg_time FROM DIARY WHERE ".
                    "YEAR(reg_time) = %d AND MONTH(reg_time) = %d ",
                        date("Y", strtotime($target_date)),
                        date("m", strtotime($target_date)));
        $res = $this->_db->query($sql);
        if ($this->_db->error) {
            throw new Exception("顼");
        }
        $ret = array();
        while($row = $res->fetch_assoc()) {
            $ret[] = $row["reg_time"];
        }
        if (count($ret) > 0) {
            return $ret;
        } else {
            return NULL;
        }
    }

    // }}}
    // {{{
    
    /**
     * 국ID
     * @param int 국ID
     * @return array nextback
     */
    function aroundGet($id)
    {
        if ($id == "") return array();
        
        $next_sql = sprintf("SELECT id FROM DIARY WHERE id > %d ".
                            "ORDER BY id ASC LIMIT 1", $id);
        $res = $this->_db->query($next_sql);
        if ($this->_db->error) {
            throw new Exception("顼");
        }
        $next = $res->fetch_assoc();
        
        $back_sql = sprintf("SELECT id FROM DIARY WHERE id < %d ".
                            "ORDER BY id DESC LIMIT 1", $id);
        $res = $this->_db->query($back_sql);
        if ($this->_db->error) {
            throw new Exception("顼");
        }
        $back = $res->fetch_assoc();
        
        return array("next" => $next["id"],
                     "back" => $back["id"]);
        
    }
    
    // }}}
}

// }}}
// {{{

/**
 * 饹
 */
class DiaryManager extends Diary {
    
    // {{{
    
    /**
     * ¸᥽å
     * @param string $path եȥե¸ǥ쥯ȥ
     * @param mixed &$sess $_SESSION
     * @return bool true
     */
    public function save($path, &$sess)
    {
        $this->connect_db();
        $sql = "SELECT MAX(id) FROM DIARY";
        $res = $this->_db->query($sql);
        if ($this->_db->error) {
            throw new Exception("顼");
        }
        $row = $res->fetch_array();
        $id = $row[0] + 1;

        //եȥե¸
        $photo_path = $this->savePhoto($id, $path, $sess["photo"]);
        $this->unlinkTmp($path);
        
        $sql = "INSERT INTO DIARY VALUES(?,?,?,?,?,?,CURRENT_TIMESTAMP)";
        $stmt = $this->_db->prepare($sql);
        $stmt->bind_param("isssss", $id,
                                    $sess["title"],
                                    $sess["body"],
                                    $photo_path[0],
                                    $photo_path[1],
                                    $photo_path[2]);
        $stmt->execute();
        if ($stmt->error) {
            throw new Exception("顼");
        }
        
        $sess = array();
        return true;
    }
    
    // }}}
    // {{{
    
    /**
     * եȥե¸᥽å
     * @param int $id ID
     * @param string $path եȥե¸ǥ쥯ȥ
     * @param array &$sess $_SESSION
     * @return array $photo_path ¸եΥѥ
     */
    public function savePhoto($id, $path, $photo)
    {
        $i = 1;
        if (!is_array($photo) || count($photo) == 0) {
            return false;
        }
        $photo = array_values($photo);
        foreach ($photo as $tmp_file) {
            list($name, $ext) = explode(".", basename($tmp_file));
            $rename_path = sprintf("%sdairy_%d_%d.%s",
                                    $path,
                                    $id,
                                    $i,
                                    $ext);
            if (!rename($tmp_file, $rename_path)) {
                throw new Exception("顼");
            }
            $photo_path[] = basename($rename_path);
            $i++;
        }
        return $photo_path;
    }
    
    // }}}
    // {{{
    
    /**
     * եȥեõ᥽å
     * @param string $path եȥե¸ǥ쥯ȥ
     * @return bool true
     */
    public function unlinkTmp($path)
    {
        $photo_files = scandir($path);
        foreach ($photo_files as $file) {
            if (is_file("$path".$file) && ereg("^tmp_", $file)) {
                if (!@unlink("$path".$file)) {
                    throw new Exception("顼");
                }
            }
        }
        return true;
    }
    
    // }}}
    // {{{
    
    /**
     * եȥե᥽å
     * @param string $path եȥե¸ǥ쥯ȥ
     * @param array &$sess $_SESSION
     * @return bool true
     */
    public function makeTmp($path, &$sess)
    {
        $this->unlinkTmp($path);
        $sess["photo"] = array();
        $i = 1;
        while (list($key, $file) = each($_FILES)) {
            $type = ereg_replace("^image/", "", $file["type"]);
            switch ($file["type"]) {
                case "image/jpeg":
                case "image/pjpeg":
                    $ext = "jpg";
                    break;
                case "image/png":
                    $ext = "png";
                    break;
                case "image/gif":
                    $ext = "gif";
                    break;
                default :
                    continue;
            }

            $file_path = "../image/photo/tmp_$i.$ext";
            if (!$file["error"]) {
                move_uploaded_file($file["tmp_name"], $file_path);
                $sess["photo"][] = $file_path;
            }
            $i++;
        }
    
    
    }
    
    // }}}
    // {{{
    
    /**
     * ϥå᥽å
     * @param array $post $_POST
     * @param array &$sess $_SESSION
     * @return bool true
     */
    public function check($post, &$sess)
    {
        if ($post["title"] == "") {
            throw new Exception("ȥ뤬Ƥޤ");
        } elseif ($post["body"] == "") {
            throw new Exception("ʸƤޤ");
        } else {
            $sess["title"] = $post["title"];
            $sess["body"] = $post["body"];
        }
    }
    
    // }}}
}

// }}}

?>