<?php
/**
 * PHP5ǻϤWebץꥱۥ ץ륹ץ
 * ץե [profiler.inc]
 * copyright(C) qnote, Inc.All right reserved.
 */
class profile {
    private $profile;
    private $start_time;
    private $last_time;
    
    function __construct()
    {
        list($mtime,$stime) = explode(" ", microtime());
        $time = $mtime + $stime;
        $this->start_time = $time;
        $this->last_time = $time;
        $this->profile[0] = "File,Line,ProcTime,";
        $this->set();
    }
    function set()
    {
        //ǿΥȥ졼̤ե̾ȹԿؿ̾
        $dbg = debug_backtrace();
        $file = basename($dbg[0]["file"]);
        $line = $dbg[0]["line"];
        $func = $dbg[1]["function"];
        unset($dbg);

        list($mtime,$stime) = explode(" ", microtime());
        $time = $mtime+$stime;

        $nowtime = $time - $this->start_time;
        $pasttime = $time - $this->last_time;
        $this->profile[] = sprintf("%s,%d,%s,%s",
                                    $file,
                                    $line,
                                    $func == "unknown" ? "":$func."()",
                                    $nowtime);
        $this->last_time = $time;
    }
    function save()
    {
        unregister_tick_function(array($this, "set"));
        $this->set();
        @file_put_contents("/tmp/profile.csv", implode("\r\n",$this->profile));
    }
}
?>