<?php
/**
 * PHP5ǻϤWebץꥱۥ ץ륹ץ
 * 󥱡 [enquete.inc]
 * copyright(C) qnote, Inc.All right reserved.
 */

//㳰顼饹
class InternalException extends Exception {
    
    function drawError($view)
    {
        $view->assign("error_msg", $this->getMessage());
        $view->display("default_error.tpl");
        exit;
    }
}
class UserException extends Exception {}



// {{{

/**
 * 󥱡饹
 */
class Enquete {
    
    // {{{ properties
    
    /**
     * @access protected
     * @var $_db object MySQLiǡ١֥ѿ
     */
    protected $_db;
    
    // }}}
    // {{{
    
    /**
     * MySQLiǡ١ϥ᥽å
     * @access protected
     */
    protected function connect_db()
    {
        $this->_db = new mysqli;
        $this->_db->connect(ENQ_DBHOST, ENQ_DBUSER, ENQ_DBPWD, ENQ_DBNAME);
        if (!$this->_db->host_info) {
            throw new InternalException("顼");
        }
    }

    // }}}
    // {{{
    
    /**
     * 󥱡ȥǡ֥ȼ᥽å
     * @access public
     * @return $ret mixed 󥱡ȥǡ֥
     */
    public function listAll()
    {
        $this->connect_db();
        $sql = "select * from ENQUETE_MASTER WHERE flg_delete = 0;";
        $res = $this->_db->query($sql);
        while($row = $res->fetch_object()) {
            $ret[] = $row;
        }
        return $ret;
    }

    // }}}
    // {{{

    public function setAnswer(stdClass $poll, $answer)
    {
        while (list($q_no, $q_obj) = @each($poll->quest)) {
            $poll->quest[$q_no]->answer = $answer[$q_no];
            if ($q_obj->required == 1 && $answer[$q_no] == "") {
                throw new UserException("".($q_no+1)."ɬܲǤ");
            }
        }
        return $poll;
    }
    
    // }}}
    // {{{
    
    /**
     * 󥱡ȸå᥽å
     * 
     */
    public function isPublic(stdClass $poll)
    {
        if ($poll->id == "") {
            throw new InternalException("õΥ󥱡Ȥ¸ߤޤ");
        }
        if (strtotime($poll->startDate) > time()) {
            throw new InternalException("Υ󥱡ȤϽǤƤޤ");
        }
        if (strtotime($poll->endDate) < time()) {
            throw new InternalException("Υ󥱡ȤμդϽλޤ");
        }
        if ($poll->flg_delete != 0) {
            throw new InternalException("Υ󥱡ȤϺޤ");
        }
        return true;
    }
    
    // }}}
    // {{{
    
    public function regist(stdClass $poll)
    {
        $this->connect_db();
        
        //ȥ󥶥å
        $this->_db->autocommit(false);
        
        //akey
        $sql = "SELECT MAX(a_key) as next_akey FROM ENQUETE_ANSWER LOCK IN SHARE MODE;";
        $res = $this->_db->query($sql);
        if ($this->_db->error) {
            throw new InternalException("顼");
        }
        $row = $res->fetch_assoc();
        $akey = $row["next_akey"] + 1;
        $res->free();
        
        //ǡץڥɥơȥ
        $sql = "INSERT INTO ENQUETE_ANSWER VALUES(?,?,?,?, CURRENT_TIMESTAMP)";
        $stmt = $this->_db->prepare($sql);
        if ($stmt->error) {
            throw new InternalException("顼");
        }
        
        //ԤINSERT
        while (list($id, $q_obj) = each($poll->quest)) {
            //ʣξϰĤ
            if (is_array($q_obj->answer)) {
                while (list(,$answer) = each($q_obj->answer)) {
                    $stmt->bind_param("iiis", $akey,
                                              $q_obj->id, 
                                              $q_obj->q_no,
                                              $answer);
                    $stmt->execute();
                    if ($stmt->error) {
                        $this->_db->rollback();
                        throw new InternalException("顼");
                    }
                }
            } else if ($q_obj->answer != "") {
                $stmt->bind_param("iiis", $akey,
                                          $q_obj->id, 
                                          $q_obj->q_no,
                                          $q_obj->answer);
                $stmt->execute();
                if ($stmt->error) {
                    $this->_db->rollback();
                    throw new InternalException("顼");
                }
            }
        }
        $stmt->close();
        $this->_db->commit();
        
        return true;
    }
    // }}}
    // {{{
    
    /**
     * 󥱡ȥǡ֥ȼ᥽å
     * @access public
     * @param $id integer 󥱡ID
     * @return $poll object 󥱡ȥǡ֥
     */
    public function getPoll($id)
    {
        if ($id == "") {
            throw new InternalException("󥱡ȤꤵƤޤ");
        }
        $this->connect_db();

        //ޥǡ
        $sql = sprintf("SELECT * FROM ENQUETE_MASTER WHERE id = %d", $id);
        $res = $this->_db->query($sql);
        if ($this->_db->error) {
            throw new InternalException("顼");
        }
        $_arr = $res->fetch_object();
        $res->free();
        
        //ǡ
        $sql = sprintf("SELECT * FROM ENQUETE_QUEST WHERE id = %d", $id);
        $res = $this->_db->query($sql);
        if ($this->_db->error) {
            throw new InternalException("顼");
        }
        $quest = array();
        while ($_obj = $res->fetch_object()) {
            $quest[] = $_obj;
        }
        $res->free();
        
        //ǡ
        $sql = sprintf("SELECT * FROM ENQUETE_OPTIONS WHERE id = %d;", $id);
        $res = $this->_db->query($sql);
        if ($this->_db->error) {
            throw new InternalException("顼");
        }
        $opt = array();
        while ($_row = $res->fetch_assoc()) {
            $quest[$_row["q_no"]]->op_string[] = $_row["op_string"];
        }
        $res->free();
        
        $_arr->quest = $quest;
        
        $poll = $_arr;
        
        return $poll;
    }


    // }}}

}

// }}}
// {{{

/**
 * 󥱡ȴ饹
 * 
 */
class EnqueteAdm extends Enquete {

    // {{{
    
    /**
     * 󥱡ȥǡ᥽å
     * @param $enq_id integer 󥱡ID
     * @return true;
     */
    public function delete($enq_id)
    {
        $this->connect_db();
        $sql = sprintf("UPDATE ENQUETE_MASTER ".
                        "SET flg_delete = 1 WHERE id = %d;", $enq_id);
        $res = $this->_db->query($sql);
        if ($res->affected_rows != 1 || $this->_db->error) {
            throw new UserException("ǤޤǤ");
        }
        return true;
    }
    
    // }}}
    // {{{
    
    /**
     * 󥱡ȥǡ֥ȼ᥽å
     * @access public
     * @param $_data array 󥱡
     * @return $poll object 󥱡ȥǡ֥
     */
    public function getPoll($_data)
    {
        $_arr = new stdClass;
        $_arr->title = $_data["title"];
        $_arr->detail = $_data["detail"];

        $_arr->startDate = sprintf("%04d-%02d-%02d %02d:%02d:00",
                                        $_data["startYear"],
                                        $_data["startMonth"],
                                        $_data["startDay"],
                                        $_data["startHour"],
                                        $_data["startMinute"]);
        $_arr->endDate =  sprintf("%04d-%02d-%02d %02d:%02d:00",
                                        $_data["endYear"],
                                        $_data["endMonth"],
                                        $_data["endDay"],
                                        $_data["endHour"],
                                        $_data["endMinute"]);
        $_arr->quest = array();
        while (list($qid, ) = @each($_POST["q_string"])) {
            $_arr->quest[$qid] = new stdClass;
            $_arr->quest[$qid]->q_string = $_data["q_string"][$qid];
            $_arr->quest[$qid]->required = $_data["required"][$qid];
            $_arr->quest[$qid]->input_type = $_data["input_type"][$qid];
            $_arr->quest[$qid]->op_string = @array_unique($_data["op_string"][$qid]);
        }
        return $_arr;
    }
    
    // }}}
    // {{{
    
    /**
     * 䥪֥ɲå᥽å
     * @access public
     * @param &$_pobj object 󥱡ȥǡ֥
     */
    public function addQuestion(stdClass $_pobj, $input_type)
    {
        $_obj = new stdClass;
        $_obj->input_type = $input_type;
        $_obj->op_string[] = "";
        $_pobj->quest[] = $_obj;
    }
    
    // }}}
    // {{{
    
    /**
     * 䥪֥Ⱥ᥽å
     * @access public
     * @param &$_pobj object 󥱡ȥǡ֥
     * @param $index integer ֹ
     */
    public function removeQuestion(stdClass $_pobj, $index)
    {
        unset($_pobj->quest[$index]);
    }
    
    // }}}
    // {{{
    
    /**
     * 䥪֥Ƚѹ᥽å
     * @access public
     * @param &$_pobj object 󥱡ȥǡ֥
     * @param $index integer ѹֹ
     * @param $offset integer ѹֹ
     */
    public function moveQuestion(stdClass $_pobj, $index, $offset)
    {
        if ($index+$offset >= count($_pobj->quest) ||
            $index+$offset < 0) {
            return false;
        }
        $_up_val = $_pobj->quest[$index];
        $_pre_val = $_pobj->quest[$index+$offset];
        $_pobj->quest[$index] = $_pre_val;
        $_pobj->quest[$index+$offset] = $_up_val;
    }
    
    // }}}
    // {{{
    
    /**
     * ɲå᥽å
     * @access public
     * @param &$_pobj object 󥱡ȥǡ֥
     * @param $index integer ѹֹ
     */
    public function addOption(stdClass $_pobj, $index)
    {
        $_pobj->quest[$index]->op_string[] = "";

    }
    
    // }}}
    // {{{
    
    /**
     * 󥱡ȥǡ֥ȥå᥽å
     * @access public
     * @param &$_pobj object 󥱡ȥǡ֥
     */
    public function check(stdClass $_pobj)
    {
        if ($_pobj->title == "") {
            throw new UserException("󥱡ȥȥ뤬̤ϤǤ");
        } elseif (strtotime($_pobj->startDate) >= strtotime($_pobj->endDate)) {
            throw new UserException("֤ޤ");
        } elseif (count($_pobj->quest) <= 0) {
            throw new UserException("䤬Ƥޤ");
        }
        
    }
    
    // }}}
    // {{{
    
    public function result($id)
    {
        $this->connect_db();

        $sql = sprintf("SELECT * FROM ENQUETE_ANSWER ".
                       "WHERE id = %d ORDER BY ins_time DESC", $id);
        $res = $this->_db->query($sql);
        if ($this->_db->error) {
            throw new InternalException("顼");
        }
        $ret = array();
        while ($row = $res->fetch_assoc()) {
            $ret[$row[a_key]][$row["q_no"]][] = $row["answer"];
            $ret[$row[a_key]]["ins_time"] = $row["ins_time"];
        }
        return $ret;
    }
    
    // }}}
    // {{{
    
    /**
     * 󥱡ȥǡ¸᥽å
     * @access public
     * @param $_data object 󥱡ȥǡ
     * @param $enq_id integer 󥱡ID
     */
    public function save($_data, $enq_id = NULL)
    {
        if (!is_object($_data)) {
            throw new InternalException("顼");
        }
        $this->connect_db();
        
        $this->_db->autocommit(false);
        
        if ($enq_id === NULL) {
            $sql = "SELECT MAX(id) as current_id FROM ENQUETE_MASTER ;";
            $res = $this->_db->query($sql);
            if ($this->_db->error) {
                throw new InternalException("顼");
            }
            $row = $res->fetch_assoc();
            $enq_id = $row["current_id"] + 1;
        } else {
            //ξϺ뤿¸Υǡ
            $sql = sprintf("DELETE FROM ENQUETE_QUEST WHERE id = %d;", $enq_id);
            $res = $this->_db->query($sql);
            if ($this->_db->error) {
                throw new InternalException("顼");
            }
            $sql = sprintf("DELETE FROM ENQUETE_OPTIONS WHERE id=%d;", $enq_id);
            $res = $this->_db->query($sql);
            if ($this->_db->error) {
                throw new InternalException("顼");
            }
        }
        
        //ޥǡ
        $sql = sprintf("REPLACE INTO ENQUETE_MASTER ".
                    "VALUES(%d, '%s', '%s', '%s', '%s', 0);",
                        $enq_id,
                        $_data->title,
                        $_data->detail,
                        $_data->startDate,
                        $_data->endDate);
        $res = $this->_db->query($sql);
        if ($this->_db->error) {
            throw new InternalException("顼");
        }
        
        //ǡΥץڥɥơȥȺ
        $sql = "INSERT INTO ENQUETE_QUEST VALUES(?, ?, ?, ?, ?)";
        $q_stmt = $this->_db->prepare($sql);
        if ($q_stmt->error) {
            $this->_db->rollback();
            throw new InternalException("顼");
        }
        
        //ǡΥץڥɥơȥȺ
        $sql = "INSERT INTO ENQUETE_OPTIONS VALUES(?, ?, ?)";
        $op_stmt = $this->_db->prepare($sql);
        if ($op_stmt->error) {
            $this->_db->rollback();
            throw new InternalException("顼");
        }
        
        //䡢襹ơȥȤμ¹
        while (list($q_no, $q_value) = each($_data->quest)) {
            $q_stmt->bind_param("iisis",
                                $enq_id,
                                $q_no,
                                $q_value->q_string,
                                $q_value->required,
                                $q_value->input_type);
            $q_stmt->execute();
            if ($q_stmt->error) {
                $this->_db->rollback();
                throw new InternalException("顼");
            }
            if (count($q_value->op_string)) {
                while (list($seq, $op_string) = @each($q_value->op_string)) {
                    if ($op_string == "") continue;
                    $op_stmt->bind_param("iis", $enq_id, $q_no, $op_string);
                    $op_stmt->execute();
                    if ($op_stmt->error) {
                        $this->_db->rollback();
                        throw new InternalException("顼");
                    }
                }
            }
        }
        $this->_db->commit();
        return true;
    }
    
    // }}}

}

// }}}

?>