<?php
/**
 * PHP5ǻϤWebץꥱۥ ץ륹ץ
 * 䤤碌ե [contact.inc]
 * copyright(C) qnote, Inc.All right reserved.
 */

//¸ǥ쥯ȥꡣ²ưhtdocsγؤ
define(CONTACT_DATA_DIR, "./data");

/**
 * 䤤碌ǡݲ饹
 */
abstract class Contact {
    protected $file_dir;

    abstract public function registData($post);
    abstract public function getData();
    
    public function escapeHtml($array)
    {
        foreach ($array as $key => $val) {
            if ($val == "") {
                continue;
            }
            $val = htmlspecialchars($val);
            $array[$key] = $val;
        }
        return $array;
    }
}


/**
 * եѥ饹
 */
class Contact_File extends Contact {
    
    public function __construct()
    {
        $this->file_dir = CONTACT_DATA_DIR;
    }
    
    public function registData($post)
    {
        $filename = $this->file_dir.date("YmdHis").".csv";
        $contents = sprintf("UNAME,TITLE,EMAIL,CTYPE,CBODY,REG_TIME\r\n".
                            "%s,%s,%s,%s,%s,%s\r\n",
                            $post["uname"],
                            $post["title"],
                            $post["email"],
                            $post["ctype"],
                            $post["cbody"],
                            date("Y-m-d H:i:s"));
        if (file_put_contents($filename, $contents)) {
            return true;
        } else {
            return false;
        }
        
    }
    public function getData()
    {
        $files = scandir($this->file_dir);
        foreach ($files as $key => $filename) {
            if (!ereg(".csv", $filename)) continue;
            $tmp_data = file_get_contents($this->file_dir.$filename);
            list($title, $row) = explode("\r\n", $tmp_data);
            $title = explode(",", $title);
            $row = explode(",", $row);
            $data[] = array_combine($title, $row);
        }
        return $data;
    }
    
}

/**
 * SQLiteѥ饹
 */
class Contact_SQLite extends Contact {
    private $db;
    
    public function __construct()
    {
        $this->file_dir = CONTACT_DATA_DIR;
        $this->db = sqlite_open($this->file_dir."/contact.db");
    }
    
    public function registData($post)
    {
        //䤤碌ǡINSERT
        $sql = sprintf("INSERT INTO CONTACT ".
                    "VALUES(NULL, '%s', '%s', '%s', '%s', '%s', '%s')",
                            $post["uname"],
                            $post["title"],
                            $post["email"],
                            $post["ctype"],
                            $post["cbody"],
                            date("Y-m-d H:i:s"));
        //ȯ
        if (sqlite_query($this->db, $sql)) {
            return true;
        } else {
            return false;
        }
        
    }
    public function getData()
    {
        $sql = sprintf("SELECT * FROM CONTACT");
        $row = sqlite_array_query($this->db, $sql, SQLITE_ASSOC);
        return $row;
    }
    
}



?>