//
//  MyCal.m
//  Calendar1
//
//  Created by 大津 真 on 09/11/13.
//  Copyright 2009 __MyCompanyName__. All rights reserved.
//

#import "MyCal.h"

@implementation MyCal

@synthesize year, month;

- (id) init
{
	if (self = [super init]) {
		//今日の日付を生成
		NSDate *today = [NSDate date];
		//暦を西暦に
		cal = [[NSCalendar alloc]
			   initWithCalendarIdentifier:NSGregorianCalendar];	
		//年と月を設定
		unsigned int unitFlags =  NSYearCalendarUnit | NSMonthCalendarUnit;
		NSDateComponents *comps = [cal components:unitFlags fromDate:today];
		year = [comps year];
		month = [comps month];
	}
	return (self);
}


- (NSString *) calStr
{
	int column = 1;
	NSMutableString *calStr;
	calStr = [NSMutableString stringWithCapacity: 40];
	[calStr appendString:@"\n Su Mo Tu We Th Fr Sa\n"];
	//最初の曜日までスキップ
	for (int i = 1; i < [self firstDay]; i++) {
		[calStr appendString:@"   "];
		column ++;
	}
	
	NSString *day;
	for (int i = 1; i <= [self daysOfMonth:month inYear:year]; i++) {
		//日付が一桁の場合はスペースを多くする
		if (i < 10) {
			day = [NSString stringWithFormat:@"  %d", i];
		} else {
			day = [NSString stringWithFormat:@" %d", i];
		}
		[calStr appendString:day];
		//7日分表示したら改行を入れる
		if (column == 7) {
			[calStr appendString:@"\n"];
			column = 0;
		}
		column ++;
	}
	
	return (calStr);
}

- (int) firstDay
{
	NSDateComponents *comps = [[NSDateComponents alloc] init];
	//今月の1日に
	[comps setDay:1];
	[comps setMonth:month];
	[comps setYear:year];
	NSDate *theDay = [cal dateFromComponents:comps];
	NSDateComponents *weekdayComps = [cal components:NSWeekdayCalendarUnit fromDate:theDay];
	return ([weekdayComps weekday]);
}	

- (int) daysOfMonth: (int) m
			 inYear: (int) y
{
	NSDateComponents *theDay = [[NSDateComponents alloc] init];
	//次の月の0日に
	[theDay setYear:year];	
	[theDay setMonth:month + 1];	
	[theDay setDay:0];	
	NSDate *date = [cal dateFromComponents:theDay];
	return ([[cal components:NSDayCalendarUnit fromDate:date] day]);
}

@end