#import <Foundation/Foundation.h>
#define BMI 22

@interface HCare : NSObject
{
	NSString *name;
	double height;
}

- (id) init;
- (id) initWithName:(NSString *) name;
- (id) initWithName:(NSString *)name height:(int)height;
- (double) stdWeight;

@property double height;
@property(copy) NSString *name;
@end


@implementation HCare


@synthesize height;
@synthesize name;

//指定イニシャライザ
- (id) initWithName:(NSString *)n height:(int)h
{
	self = [super init];	
	if (self != nil) {	
		name = n;
		height = h;
	}
	return (self);	
}


- (id) initWithName:(NSString *)n
{
	self = [self initWithName:n height: -1];
	return (self);
}

- (id) init
{
	self = [self initWithName:@"NO NAME" height: -1];
	return (self);
}
		

- (double) stdWeight
{
	return(pow((height / 100), 2) * BMI);
}

@end


int main (int argc, const char * argv[]) {
	HCare *person1, *person2, *person3;
	person1 = [[HCare alloc] init];
	NSLog(@"%@ :%.1fcm", person1.name, person1.height);
	
	person2 = [[HCare alloc] initWithName:@"YAMADA HANAKO"];
	NSLog(@"%@ :%.1fcm", person2.name, person2.height);
	
	person3 = [[HCare alloc] initWithName:@"HOSI JUN" height:160];
	NSLog(@"%@ :%.1fcm", person3.name, person3.height);
	
}
