#import <Foundation/Foundation.h>

int main (int argc, const char * argv[]) {
    NSAutoreleasePool * pool = [[NSAutoreleasePool alloc] init];

	NSArray *weekday = [NSArray arrayWithObjects:@"SUN", @"MON", @"TUE", @"WED", @"THU", @"FRI", @"SUN", nil];
	
	
	NSDate *today = [NSDate date];
	NSCalendar *cal = [[NSCalendar alloc]
					   initWithCalendarIdentifier:NSGregorianCalendar];
	NSUInteger flags = NSYearCalendarUnit | NSMonthCalendarUnit | NSDayCalendarUnit | NSWeekdayCalendarUnit;
	NSDateComponents *comps = [cal components:flags fromDate:today];
	
	NSLog(@"year: %d",[comps year]);
	NSLog(@"month: %d",[comps month]);
	NSLog(@"day: %d",[comps day]);
	NSLog(@"weekday: %@",[weekday objectAtIndex:[comps weekday] - 1]);
	
    [pool drain];
    return 0;
}
