/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package servlets;

import java.io.*;
import java.net.*;

import java.util.Date;
import java.util.Properties;
import javax.activation.DataHandler;
import javax.activation.FileDataSource;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.mail.internet.MimeUtility;
import javax.servlet.*;
import javax.servlet.http.*;

/**
 *
 * @author naoki
 */
public class MailSendServlet extends HttpServlet {
   
    /** 
    * Processes requests for both HTTP <code>GET</code> and <code>POST</code> methods.
    * @param request servlet request
    * @param response servlet response
    */
    protected void processRequest(HttpServletRequest request, HttpServletResponse response)
    throws ServletException, IOException {
        String to = request.getParameter("to");
        String subject = request.getParameter("subject");
        String message = request.getParameter("message");

        //SMTPサーバーの設定
        Properties props = new Properties();
        props.put("mail.smtp.host", "mail");
        Session sess = Session.getInstance(props);

        try{
            MimeMessage msg = new MimeMessage(sess);
            InternetAddress[] toList = InternetAddress.parse(to);
            msg.addRecipients(MimeMessage.RecipientType.TO, toList);//送信先
            InternetAddress fromAddress = new InternetAddress("sender@example.com");
            msg.setFrom(fromAddress);//送信元
            msg.setSentDate(new Date());//送信日付
            msg.setSubject(subject, "ISO-2022-JP");//件名
            //メッセージ本体
            MimeMultipart mm = new MimeMultipart();
            //本文
            MimeBodyPart mbText = new MimeBodyPart();
            if(!message.endsWith("\n")) message += "\n";
            mbText.setText(message, "ISO-2022-JP");
            mm.addBodyPart(mbText);
            //ファイルの位置を得る
            ServletContext appliction = getServletContext();
            String path = appliction.getRealPath("/mailform.jsp");
            //添付ファイル
            MimeBodyPart mbFile = new MimeBodyPart();
            FileDataSource fds = new FileDataSource(path);
            DataHandler dh = new DataHandler(fds);
            mbFile.setDataHandler(dh);
            String filename = MimeUtility.encodeText("テスト.txt");
            mbFile.setFileName(filename);
            mm.addBodyPart(mbFile);
            msg.setContent(mm);
            //送信実行
            Transport.send(msg);
        }catch(MessagingException e){
            throw new ServletException(e);
        }

        RequestDispatcher rd = request.getRequestDispatcher("/mailsend.jsp");
        rd.forward(request, response);
    } 

    // <editor-fold defaultstate="collapsed" desc="HttpServlet のメソッドです。コードを編集するには、左側の + 符号をクリックしてください。">
    /** 
    * Handles the HTTP <code>GET</code> method.
    * @param request servlet request
    * @param response servlet response
    */
    protected void doGet(HttpServletRequest request, HttpServletResponse response)
    throws ServletException, IOException {
        processRequest(request, response);
    } 

    /** 
    * Handles the HTTP <code>POST</code> method.
    * @param request servlet request
    * @param response servlet response
    */
    protected void doPost(HttpServletRequest request, HttpServletResponse response)
    throws ServletException, IOException {
        processRequest(request, response);
    }

    /** 
    * Returns a short description of the servlet.
    */
    public String getServletInfo() {
        return "Short description";
    }
    // </editor-fold>
}
