/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package servlets;

import java.io.*;
import java.net.*;

import java.util.List;
import javax.servlet.*;
import javax.servlet.http.*;
import org.apache.commons.fileupload.DiskFileUpload;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileUploadException;

/**
 *
 * @author naoki
 */
public class FileReceiveServlet extends HttpServlet {
   
    /** 
    * Processes requests for both HTTP <code>GET</code> and <code>POST</code> methods.
    * @param request servlet request
    * @param response servlet response
    */
    protected void processRequest(HttpServletRequest request, HttpServletResponse response)
    throws ServletException, IOException {
        response.setContentType("text/html;charset=UTF-8");
        PrintWriter out = response.getWriter();
        try {
            out.println("<h1>受け取り</h1>");
            if(!DiskFileUpload.isMultipartContent(request)){
                out.println("ファイルアップロードではない");
                out.close();
                return;
            }
            DiskFileUpload fu = new DiskFileUpload();
            fu.setSizeMax(1024000);
            fu.setHeaderEncoding("UTF-8");
            String format = "%s:%s<br>%n";

            List<FileItem> items = fu.parseRequest(request);
            for(FileItem item : items){
                out.printf(format, "フィールド名", item.getFieldName());
                if(item.isFormField()){
                    //通常のフィールド
                    out.printf(format, "内容", item.getString("UTF-8"));
                } else{
                    //ファイルのフィールド
                    out.printf(format, "ファイル名", item.getName());
                    out.printf(format, "サイズ", item.getSize());
                    item.delete();
                }
                out.println("<br>");
            }
        }catch(FileUploadException e){
            throw new ServletException(e);
        } finally { 
            out.close();
        }
    } 

    // <editor-fold defaultstate="collapsed" desc="HttpServlet のメソッドです。コードを編集するには、左側の + 符号をクリックしてください。">
    /** 
    * Handles the HTTP <code>GET</code> method.
    * @param request servlet request
    * @param response servlet response
    */
    protected void doGet(HttpServletRequest request, HttpServletResponse response)
    throws ServletException, IOException {
        processRequest(request, response);
    } 

    /** 
    * Handles the HTTP <code>POST</code> method.
    * @param request servlet request
    * @param response servlet response
    */
    protected void doPost(HttpServletRequest request, HttpServletResponse response)
    throws ServletException, IOException {
        processRequest(request, response);
    }

    /** 
    * Returns a short description of the servlet.
    */
    public String getServletInfo() {
        return "Short description";
    }
    // </editor-fold>
}
