/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package servlets;

import java.io.*;
import java.net.*;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.*;
import javax.servlet.http.*;
import javax.sql.DataSource;

/**
 *
 * @author naoki
 */
public class DatabaseServlet extends HttpServlet {
    @Resource(name="jdbc/test")
    DataSource jdbcTest;
    /** 
    * Processes requests for both HTTP <code>GET</code> and <code>POST</code> methods.
    * @param request servlet request
    * @param response servlet response
    */
    protected void processRequest(HttpServletRequest request, HttpServletResponse response)
    throws ServletException, IOException {
        Connection con = null;
        try{
            con = jdbcTest.getConnection();
            Statement stmt = con.createStatement();
            String sql = "select * from T_SHOHIN";
            ResultSet rs = stmt.executeQuery(sql);
            List<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
            while(rs.next()){
                Map<String, Object> record = new HashMap<String, Object>();
                record.put("id", new Integer(rs.getInt("SHOHIN_ID")));
                record.put("name", rs.getString("SHOHIN_NAME"));
                record.put("price", new Integer(rs.getInt("PRICE")));
                list.add(record);
            }
            rs.close();
            stmt.close();
            request.setAttribute("data", list);

            RequestDispatcher rd = request.getRequestDispatcher("/database.jsp");
            rd.forward(request, response);
        } catch(Exception e){
            throw new ServletException(e);
        } finally{
            try{
                if(con != null) con.close();
            } catch(SQLException e){
                throw new ServletException(e);
            }
        }
    } 

    // <editor-fold defaultstate="collapsed" desc="HttpServlet のメソッドです。コードを編集するには、左側の + 符号をクリックしてください。">
    /** 
    * Handles the HTTP <code>GET</code> method.
    * @param request servlet request
    * @param response servlet response
    */
    protected void doGet(HttpServletRequest request, HttpServletResponse response)
    throws ServletException, IOException {
        processRequest(request, response);
    } 

    /** 
    * Handles the HTTP <code>POST</code> method.
    * @param request servlet request
    * @param response servlet response
    */
    protected void doPost(HttpServletRequest request, HttpServletResponse response)
    throws ServletException, IOException {
        processRequest(request, response);
    }

    /** 
    * Returns a short description of the servlet.
    */
    public String getServletInfo() {
        return "Short description";
    }
    // </editor-fold>
}
