/*
 * PrintSample.java
 *
 * Created on 2007/11/26, 1:37
 */

package library;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import javax.print.Doc;
import javax.print.DocFlavor;
import javax.print.DocPrintJob;
import javax.print.PrintException;
import javax.print.PrintService;
import javax.print.PrintServiceLookup;
import javax.print.ServiceUI;
import javax.print.SimpleDoc;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.PrintRequestAttributeSet;
import javax.print.attribute.standard.Chromaticity;
import javax.print.attribute.standard.JobName;
import javax.print.attribute.standard.MediaSizeName;
import javax.print.attribute.standard.OrientationRequested;
import javax.swing.ImageIcon;

/**
 *
 * @author  naoki
 */
public class PrintSample extends javax.swing.JFrame {
    
    /** Creates new form PrintSample */
    public PrintSample() {
        initComponents();
        
        Image img = createImage(350, 250);
        Graphics g = img.getGraphics();
        paintData(g);
        g.dispose();
        ImageIcon icon = new ImageIcon(img);
        lblPreview.setIcon(icon);        
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        btnPrint = new javax.swing.JButton();
        lblPreview = new javax.swing.JLabel();

        setDefaultCloseOperation(javax.swing.WindowConstants.EXIT_ON_CLOSE);

        btnPrint.setText("印刷");
        btnPrint.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                btnPrintActionPerformed(evt);
            }
        });

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(getContentPane());
        getContentPane().setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(layout.createSequentialGroup()
                        .addGap(161, 161, 161)
                        .addComponent(btnPrint))
                    .addGroup(layout.createSequentialGroup()
                        .addContainerGap()
                        .addComponent(lblPreview, javax.swing.GroupLayout.DEFAULT_SIZE, 376, Short.MAX_VALUE)))
                .addContainerGap())
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addComponent(btnPrint)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(lblPreview, javax.swing.GroupLayout.DEFAULT_SIZE, 253, Short.MAX_VALUE)
                .addContainerGap())
        );

        pack();
    }// </editor-fold>//GEN-END:initComponents

    /** 印刷画像の生成 */
    public void paintData(Graphics g){
        g.fillRect(10, 30, 170, 30);
        g.fillRect(10, 65, 170, 30);
        g.fillRect(10, 100, 170, 30);
        g.setFont(new Font("Serif", Font.PLAIN, 20));
        g.drawString("Easy Sample:文字列の描画", 100, 180);
        g.setFont(new Font("SansSerif", Font.ITALIC, 20));
        g.drawString("Easy Sample:文字列の描画", 100, 210);
        g.setColor(Color.CYAN);
        g.fillOval(50, 45, 70, 70);
    }

    /** 印刷データ */
    class SamplePrint implements Printable{
        public int print(Graphics g, PageFormat pf, int pageIndex){
            if(pageIndex > 0) return Printable.NO_SUCH_PAGE;
            double x = pf.getImageableX();
            double y = pf.getImageableY();
            ((Graphics2D)g).translate(x, y);
            paintData(g);
            return Printable.PAGE_EXISTS;
        }
    }

    /** 印刷ボタンの処理 */    
    private void btnPrintActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_btnPrintActionPerformed
        //プリンタ一覧の取得
        PrintService[] services =
                PrintServiceLookup.lookupPrintServices(null, null);
        if(services.length == 0){
            //プリンタがない
            return;
        }
        //現在のプリンタの取得
        PrintService defaultService =
                PrintServiceLookup.lookupDefaultPrintService();
        //印刷するデータの種類を指定
        DocFlavor flavor = DocFlavor.SERVICE_FORMATTED.PRINTABLE;
        //印刷書式の指定
        PrintRequestAttributeSet pras =
                new HashPrintRequestAttributeSet();
        pras.add(new JobName("印刷テスト", null));
        pras.add(MediaSizeName.ISO_A4);
        pras.add(Chromaticity.MONOCHROME);
        pras.add(OrientationRequested.LANDSCAPE);
        //印刷ダイアログの表示
        PrintService ps = ServiceUI.printDialog(null, 50, 50,
            services, defaultService, flavor, pras);
        if(ps == null){
            //キャンセルされた
            return;
        }
        //印刷実行
        DocPrintJob job = ps.createPrintJob();
        Printable print = new SamplePrint();
        Doc doc = new SimpleDoc(print, flavor, null);
        try{
            job.print(doc, pras);
        } catch (PrintException e){
            e.printStackTrace();
        }
}//GEN-LAST:event_btnPrintActionPerformed
    
    /**
     * @param args the command line arguments
     */
    public static void main(String args[]) {
        java.awt.EventQueue.invokeLater(new Runnable() {
            public void run() {
                new PrintSample().setVisible(true);
            }
        });
    }
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton btnPrint;
    private javax.swing.JLabel lblPreview;
    // End of variables declaration//GEN-END:variables
    
}
