/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package jpa;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.Serializable;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.NamedQueries;
import javax.persistence.Table;
import javax.persistence.Transient;

/**
 *
 * @author naoki
 */
@Entity
@Table(name = "T_SHOHIN")
@NamedQueries({})
public class TShohin implements Serializable {
    @Transient
    private PropertyChangeSupport changeSupport = new PropertyChangeSupport(this);
    private static final long serialVersionUID = 1L;
    @Id
    @Column(name = "SHOHIN_ID", nullable = false)
    private Integer shohinId;
    @Column(name = "SHOHIN_NAME")
    private String shohinName;
    @Column(name = "PRICE")
    private Integer price;
    @JoinColumn(name = "BUNRUI_ID", referencedColumnName = "BUNRUI_ID")
    @ManyToOne
    private TBunrui bunruiId;

    public TShohin() {
    }

    public TShohin(Integer shohinId) {
        this.shohinId = shohinId;
    }

    public Integer getShohinId() {
        return shohinId;
    }

    public void setShohinId(Integer shohinId) {
        Integer oldShohinId = this.shohinId;
        this.shohinId = shohinId;
        changeSupport.firePropertyChange("shohinId", oldShohinId, shohinId);
    }

    public String getShohinName() {
        return shohinName;
    }

    public void setShohinName(String shohinName) {
        String oldShohinName = this.shohinName;
        this.shohinName = shohinName;
        changeSupport.firePropertyChange("shohinName", oldShohinName, shohinName);
    }

    public Integer getPrice() {
        return price;
    }

    public void setPrice(Integer price) {
        Integer oldPrice = this.price;
        this.price = price;
        changeSupport.firePropertyChange("price", oldPrice, price);
    }

    public TBunrui getBunruiId() {
        return bunruiId;
    }

    public void setBunruiId(TBunrui bunruiId) {
        TBunrui oldBunruiId = this.bunruiId;
        this.bunruiId = bunruiId;
        changeSupport.firePropertyChange("bunruiId", oldBunruiId, bunruiId);
    }

    @Override
    public int hashCode() {
        int hash = 0;
        hash += (shohinId != null ? shohinId.hashCode() : 0);
        return hash;
    }

    @Override
    public boolean equals(Object object) {
        // TODO: Warning - this method won't work in the case the id fields are not set
        if (!(object instanceof TShohin)) {
            return false;
        }
        TShohin other = (TShohin) object;
        if ((this.shohinId == null && other.shohinId != null) || (this.shohinId != null && !this.shohinId.equals(other.shohinId))) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        return "jpa.TShohin[shohinId=" + shohinId + "]";
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        changeSupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        changeSupport.addPropertyChangeListener(listener);
    }

}
